/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.OMStreamArray;
import com.plpdf.smmodel.common.SMStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PDFCloneUtility {
    private SMDocument destination;
    private Map<Object, OMBase> clonedVersion = new HashMap<Object, OMBase>();

    public PDFCloneUtility(SMDocument dest) {
        this.destination = dest;
    }

    public SMDocument getDestination() {
        return this.destination;
    }

    public OMBase cloneForNewDocument(Object base) throws IOException {
        if (base == null) {
            return null;
        }
        OMBase retval = this.clonedVersion.get(base);
        if (retval == null) {
            if (base instanceof List) {
                OMArray array = new OMArray();
                List list = (List)base;
                int i = 0;
                while (i < list.size()) {
                    array.add(this.cloneForNewDocument(list.get(i)));
                    ++i;
                }
                retval = array;
            } else if (base instanceof OMObjectable && !(base instanceof OMBase)) {
                retval = this.cloneForNewDocument(((OMObjectable)base).getOMObject());
                this.clonedVersion.put(base, retval);
            } else if (base instanceof OMObject) {
                OMObject object = (OMObject)base;
                retval = this.cloneForNewDocument(object.getObject());
                this.clonedVersion.put(base, retval);
            } else if (base instanceof OMArray) {
                OMArray newArray = new OMArray();
                OMArray array = (OMArray)base;
                int i = 0;
                while (i < array.size()) {
                    newArray.add(this.cloneForNewDocument(array.get(i)));
                    ++i;
                }
                retval = newArray;
                this.clonedVersion.put(base, retval);
            } else if (base instanceof OMStreamArray) {
                OMStreamArray originalStreamArray = (OMStreamArray)base;
                OMArray newArray = new OMArray();
                int i = 0;
                while (i < originalStreamArray.getStreamCount()) {
                    OMStream originalStream = originalStreamArray.getstream(i);
                    SMStream stream = new SMStream(this.destination, originalStream.getFilteredStream(), true);
                    List<OMName> keys = originalStream.keyList();
                    int i1 = 0;
                    while (i1 < keys.size()) {
                        OMName key = keys.get(i1);
                        stream.getStream().setItem(key, this.cloneForNewDocument(originalStream.getItem(key)));
                        ++i1;
                    }
                    newArray.add(stream);
                    ++i;
                }
                OMStreamArray StreamArray = new OMStreamArray(newArray);
                this.clonedVersion.put(base, StreamArray);
                retval = StreamArray;
            } else if (base instanceof OMStream) {
                OMStream originalStream = (OMStream)base;
                SMStream stream = new SMStream(this.destination, originalStream.getFilteredStream(), true);
                this.clonedVersion.put(base, stream.getStream());
                for (Map.Entry<OMName, OMBase> entry : originalStream.entrySet()) {
                    stream.getStream().setItem(entry.getKey(), this.cloneForNewDocument(entry.getValue()));
                }
                retval = stream.getStream();
            } else if (base instanceof OMDictionary) {
                OMDictionary dic = (OMDictionary)base;
                retval = new OMDictionary();
                this.clonedVersion.put(base, retval);
                for (Map.Entry<OMName, OMBase> entry : dic.entrySet()) {
                    ((OMDictionary)retval).setItem(entry.getKey(), this.cloneForNewDocument(entry.getValue()));
                }
            } else {
                retval = (OMBase)base;
            }
        }
        this.clonedVersion.put(base, retval);
        return retval;
    }

    public void cloneMerge(OMObjectable base, OMObjectable target) throws IOException {
        if (base == null) {
            return;
        }
        OMBase retval = this.clonedVersion.get(base);
        if (retval != null) {
            return;
        }
        if (base instanceof List) {
            OMArray array = new OMArray();
            List list = (List)((Object)base);
            int i = 0;
            while (i < list.size()) {
                array.add(this.cloneForNewDocument(list.get(i)));
                ++i;
            }
            ((List)((Object)target)).add(array);
        } else if (base instanceof OMObjectable && !(base instanceof OMBase)) {
            this.cloneMerge(base.getOMObject(), target.getOMObject());
            this.clonedVersion.put(base, retval);
        } else if (base instanceof OMObject) {
            if (target instanceof OMObject) {
                this.cloneMerge(((OMObject)base).getObject(), ((OMObject)target).getObject());
            } else if (target instanceof OMDictionary) {
                this.cloneMerge(((OMObject)base).getObject(), (OMDictionary)target);
            }
            this.clonedVersion.put(base, retval);
        } else if (base instanceof OMArray) {
            OMArray array = (OMArray)base;
            int i = 0;
            while (i < array.size()) {
                ((OMArray)target).add(this.cloneForNewDocument(array.get(i)));
                ++i;
            }
            this.clonedVersion.put(base, retval);
        } else if (base instanceof OMStream) {
            OMStream originalStream = (OMStream)base;
            SMStream stream = new SMStream(this.destination, originalStream.getFilteredStream(), true);
            this.clonedVersion.put(base, stream.getStream());
            for (Map.Entry<OMName, OMBase> entry : originalStream.entrySet()) {
                stream.getStream().setItem(entry.getKey(), this.cloneForNewDocument(entry.getValue()));
            }
            retval = stream.getStream();
            target = retval;
        } else if (base instanceof OMDictionary) {
            OMDictionary dic = (OMDictionary)base;
            this.clonedVersion.put(base, retval);
            for (Map.Entry<OMName, OMBase> entry : dic.entrySet()) {
                OMName key = entry.getKey();
                OMBase value = entry.getValue();
                if (((OMDictionary)target).getItem(key) != null) {
                    this.cloneMerge(value, ((OMDictionary)target).getItem(key));
                    continue;
                }
                ((OMDictionary)target).setItem(key, this.cloneForNewDocument(value));
            }
        } else {
            retval = (OMBase)base;
        }
        this.clonedVersion.put(base, retval);
    }
}

