/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util;

import com.plpdf.font.util.BoundingBox;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMDocumentCatalog;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.edit.SMPageContentStream;
import com.plpdf.smmodel.graphics.optionalcontent.SMOptionalContentGroup;
import com.plpdf.smmodel.graphics.optionalcontent.SMOptionalContentProperties;
import com.plpdf.smmodel.graphics.xobject.SMXObjectForm;
import com.plpdf.smmodel.markedcontent.SMPropertyList;
import com.plpdf.util.Matrix;
import com.plpdf.util.PDFCloneUtility;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerUtility {
    private static final boolean DEBUG = true;
    private SMDocument targetDoc;
    private PDFCloneUtility cloner;
    private static final Set<String> PAGE_TO_FORM_FILTER = new HashSet<String>(Arrays.asList("Group", "LastModified", "Metadata"));

    public LayerUtility(SMDocument document) {
        this.targetDoc = document;
        this.cloner = new PDFCloneUtility(document);
    }

    public SMDocument getDocument() {
        return this.targetDoc;
    }

    public void wrapInSaveRestore(SMPage page) throws IOException {
        OMDictionary saveGraphicsStateDic = new OMDictionary();
        OMStream saveGraphicsStateStream = this.getDocument().getDocument().createCOSStream(saveGraphicsStateDic);
        OutputStream saveStream = saveGraphicsStateStream.createUnfilteredStream();
        saveStream.write("q\n".getBytes("ISO-8859-1"));
        saveStream.flush();
        OMStream restoreGraphicsStateStream = this.getDocument().getDocument().createCOSStream(saveGraphicsStateDic);
        OutputStream restoreStream = restoreGraphicsStateStream.createUnfilteredStream();
        restoreStream.write("Q\n".getBytes("ISO-8859-1"));
        restoreStream.flush();
        OMDictionary pageDictionary = page.getOMDictionary();
        OMBase contents = pageDictionary.getDictionaryObject(OMName.CONTENTS);
        if (contents instanceof OMStream) {
            OMStream contentsStream = (OMStream)contents;
            OMArray array = new OMArray();
            array.add(saveGraphicsStateStream);
            array.add(contentsStream);
            array.add(restoreGraphicsStateStream);
            pageDictionary.setItem(OMName.CONTENTS, (OMBase)array);
        } else if (contents instanceof OMArray) {
            OMArray contentsArray = (OMArray)contents;
            contentsArray.add(0, saveGraphicsStateStream);
            contentsArray.add(restoreGraphicsStateStream);
        } else {
            throw new IOException("Contents are unknown type: " + contents.getClass().getName());
        }
    }

    public SMXObjectForm importPageAsForm(SMDocument sourceDoc, int pageNumber) throws IOException {
        SMPage page = (SMPage)sourceDoc.getDocumentCatalog().getAllPages().get(pageNumber);
        return this.importPageAsForm(sourceDoc, page);
    }

    public SMXObjectForm importPageAsForm(SMDocument sourceDoc, SMPage page) throws IOException {
        OMStream pageStream = (OMStream)page.getContents().getOMObject();
        SMStream newStream = new SMStream(this.targetDoc, pageStream.getUnfilteredStream(), false);
        SMXObjectForm form = new SMXObjectForm(newStream);
        SMResources pageRes = page.findResources();
        SMResources formRes = new SMResources();
        this.cloner.cloneMerge(pageRes, formRes);
        form.setResources(formRes);
        this.transferDict(page.getOMDictionary(), form.getOMStream(), PAGE_TO_FORM_FILTER, true);
        Matrix matrix = form.getMatrix();
        AffineTransform at = matrix != null ? matrix.createAffineTransform() : new AffineTransform();
        SMRectangle mediaBox = page.findMediaBox();
        SMRectangle cropBox = page.findCropBox();
        SMRectangle viewBox = cropBox != null ? cropBox : mediaBox;
        int rotation = LayerUtility.getNormalizedRotation(page);
        at.translate(mediaBox.getLowerLeftX() - viewBox.getLowerLeftX(), mediaBox.getLowerLeftY() - viewBox.getLowerLeftY());
        switch (rotation) {
            case 90: {
                at.scale(viewBox.getWidth() / viewBox.getHeight(), viewBox.getHeight() / viewBox.getWidth());
                at.translate(0.0, viewBox.getWidth());
                at.rotate(-1.5707963267948966);
                break;
            }
            case 180: {
                at.translate(viewBox.getWidth(), viewBox.getHeight());
                at.rotate(-Math.PI);
                break;
            }
            case 270: {
                at.scale(viewBox.getWidth() / viewBox.getHeight(), viewBox.getHeight() / viewBox.getWidth());
                at.translate(viewBox.getHeight(), 0.0);
                at.rotate(-4.71238898038469);
            }
        }
        at.translate(-viewBox.getLowerLeftX(), -viewBox.getLowerLeftY());
        if (!at.isIdentity()) {
            form.setMatrix(at);
        }
        BoundingBox bbox = new BoundingBox();
        bbox.setLowerLeftX(viewBox.getLowerLeftX());
        bbox.setLowerLeftY(viewBox.getLowerLeftY());
        bbox.setUpperRightX(viewBox.getUpperRightX());
        bbox.setUpperRightY(viewBox.getUpperRightY());
        form.setBBox(new SMRectangle(bbox));
        return form;
    }

    public SMOptionalContentGroup appendFormAsLayer(SMPage targetPage, SMXObjectForm form, AffineTransform transform, String layerName) throws IOException {
        OMName resourceName;
        SMOptionalContentGroup ocg;
        SMDocumentCatalog catalog = this.targetDoc.getDocumentCatalog();
        SMOptionalContentProperties ocprops = catalog.getOCProperties();
        if (ocprops == null) {
            ocprops = new SMOptionalContentProperties();
            catalog.setOCProperties(ocprops);
        }
        if (ocprops.hasGroup(layerName)) {
            throw new IllegalArgumentException("Optional group (layer) already exists: " + layerName);
        }
        SMOptionalContentGroup layer = new SMOptionalContentGroup(layerName);
        ocprops.addGroup(layer);
        SMResources resources = targetPage.findResources();
        SMPropertyList props = resources.getProperties();
        if (props == null) {
            props = new SMPropertyList();
            resources.setProperties(props);
        }
        int index = 0;
        do {
            resourceName = OMName.getPDFName("MC" + index);
            ocg = props.getOptionalContentGroup(resourceName);
            ++index;
        } while (ocg != null);
        props.putMapping(resourceName, layer);
        SMPageContentStream contentStream = new SMPageContentStream(this.targetDoc, targetPage, true, false);
        contentStream.beginMarkedContentSequence(OMName.OC, resourceName);
        contentStream.drawXObject(form, transform);
        contentStream.endMarkedContentSequence();
        contentStream.close();
        return layer;
    }

    private void transferDict(OMDictionary orgDict, OMDictionary targetDict, Set<String> filter, boolean inclusive) throws IOException {
        for (Map.Entry<OMName, OMBase> entry : orgDict.entrySet()) {
            OMName key = entry.getKey();
            if (inclusive && !filter.contains(key.getName()) || !inclusive && filter.contains(key.getName())) continue;
            targetDict.setItem(key, this.cloner.cloneForNewDocument(entry.getValue()));
        }
    }

    private static int getNormalizedRotation(SMPage page) {
        int rotation = page.findRotation();
        while (rotation >= 360) {
            rotation -= 360;
        }
        if (rotation < 0) {
            rotation = 0;
        }
        switch (rotation) {
            case 90: 
            case 180: 
            case 270: {
                return rotation;
            }
        }
        return 0;
    }
}

