/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.graphics.color.SMColorSpace;
import com.plpdf.smmodel.graphics.color.SMColorSpaceFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ImageParameters {
    private OMDictionary dictionary;

    public ImageParameters() {
        this.dictionary = new OMDictionary();
    }

    public ImageParameters(OMDictionary params) {
        this.dictionary = params;
    }

    public OMDictionary getDictionary() {
        return this.dictionary;
    }

    private OMBase getOMObject(OMName abbreviatedName, OMName name) {
        OMBase retval = this.dictionary.getDictionaryObject(abbreviatedName);
        if (retval == null) {
            retval = this.dictionary.getDictionaryObject(name);
        }
        return retval;
    }

    private int getNumberOrNegativeOne(OMName abbreviatedName, OMName name) {
        int retval = -1;
        OMNumber number = (OMNumber)this.getOMObject(abbreviatedName, name);
        if (number != null) {
            retval = number.intValue();
        }
        return retval;
    }

    public int getBitsPerComponent() {
        return this.getNumberOrNegativeOne(OMName.BPC, OMName.BITS_PER_COMPONENT);
    }

    public void setBitsPerComponent(int bpc) {
        this.dictionary.setInt(OMName.BPC, bpc);
    }

    public SMColorSpace getColorSpace() throws IOException {
        return this.getColorSpace(null);
    }

    public SMColorSpace getColorSpace(Map colorSpaces) throws IOException {
        OMBase cs = this.getOMObject(OMName.CS, OMName.COLORSPACE);
        SMColorSpace retval = null;
        if (cs != null) {
            retval = SMColorSpaceFactory.createColorSpace(cs, (Map<String, SMColorSpace>)colorSpaces);
        }
        return retval;
    }

    public void setColorSpace(SMColorSpace cs) {
        OMBase base = null;
        if (cs != null) {
            base = cs.getOMObject();
        }
        this.dictionary.setItem(OMName.CS, base);
    }

    public int getHeight() {
        return this.getNumberOrNegativeOne(OMName.H, OMName.HEIGHT);
    }

    public void setHeight(int h) {
        this.dictionary.setInt(OMName.H, h);
    }

    public int getWidth() {
        return this.getNumberOrNegativeOne(OMName.W, OMName.WIDTH);
    }

    public void setWidth(int w) {
        this.dictionary.setInt(OMName.W, w);
    }

    public List getFilters() {
        List<String> retval = null;
        OMBase filters = this.dictionary.getDictionaryObject(new String[]{"Filter", "F"});
        if (filters instanceof OMName) {
            OMName name = (OMName)filters;
            retval = new OMArrayList<String>(name.getName(), (OMBase)name, this.dictionary, OMName.FILTER);
        } else if (filters instanceof OMArray) {
            retval = OMArrayList.convertOMNameOMArrayToList((OMArray)filters);
        }
        return retval;
    }

    public void setFilters(List filters) {
        OMArray obj = OMArrayList.convertStringListToOMNameOMArray(filters);
        this.dictionary.setItem("Filter", (OMBase)obj);
    }
}

