/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.util;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMDocumentCatalog;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.edit.SMPageContentStream;
import com.plpdf.smmodel.font.SMFont;
import com.plpdf.smmodel.graphics.xobject.SMXObjectForm;
import com.plpdf.smmodel.interactive.annotation.SMAnnotation;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationWidget;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceDictionary;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceStream;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.smmodel.interactive.form.SMCheckbox;
import com.plpdf.smmodel.interactive.form.SMChoiceField;
import com.plpdf.smmodel.interactive.form.SMField;
import com.plpdf.smmodel.interactive.form.SMRadioCollection;
import com.plpdf.smmodel.interactive.form.SMVariableText;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flattener {
    static SMDocumentCatalog catalog;
    static SMAcroForm acroForm;
    static SMResources formresources;
    static Map<String, SMFont> formfonts;
    static SMDocument document;

    public static void f(SMDocument doc) throws Exception {
        SMPage page;
        document = doc;
        catalog = doc.getDocumentCatalog();
        acroForm = catalog.getAcroForm();
        formresources = acroForm.getDefaultResources();
        formfonts = formresources.getFonts();
        List<SMField> fields = acroForm.getFields();
        List allPages = doc.getDocumentCatalog().getAllPages();
        int i = 0;
        while (i < allPages.size()) {
            page = (SMPage)allPages.get(i);
            List<SMAnnotation> anns = page.getAnnotations();
            ListIterator<SMAnnotation> annotiterator = anns.listIterator();
            while (annotiterator.hasNext()) {
                SMAnnotation annot = annotiterator.next();
                SMPage annpage = annot.getPage();
                if (annpage != null) continue;
                annot.setPage(page);
            }
            ++i;
        }
        i = 0;
        while (i < allPages.size()) {
            page = (SMPage)allPages.get(i);
            SMPageContentStream contentStream = new SMPageContentStream(doc, page, true, true);
            contentStream.saveGraphicsState();
            for (SMField field : fields) {
                SMPage fieldpage = field.getWidget().getPage();
                if (fieldpage == null || !fieldpage.equals(page)) continue;
                Flattener.fieldflatten1(field, contentStream, formfonts);
            }
            contentStream.restoreGraphicsState();
            contentStream.close();
            Integer indx = 0;
            OMArrayList<SMAnnotation> newanns = new OMArrayList<SMAnnotation>();
            List<SMAnnotation> anns = page.getAnnotations();
            ListIterator<SMAnnotation> annotiterator = anns.listIterator();
            while (annotiterator.hasNext()) {
                OMObjectable next = annotiterator.next();
                if (next instanceof SMAnnotationWidget) continue;
                newanns.add((SMAnnotation)next);
                indx = indx + 1;
            }
            page.setAnnotations(newanns);
            ++i;
        }
        for (SMField field : fields) {
            List<OMObjectable> kids = field.getKids();
            if (kids == null) continue;
            kids.clear();
        }
        fields.clear();
        ((OMDictionary)catalog.getOMObject()).removeItem(OMName.ACRO_FORM);
    }

    static void fieldflatten1(SMField field, SMPageContentStream contentStream, Map<String, SMFont> formfonts) throws Exception {
        if (field instanceof SMVariableText) {
            contentStream.saveGraphicsState();
            Flattener.TextFieldFlatten(field, contentStream, formfonts);
            contentStream.restoreGraphicsState();
        } else if (!(field instanceof SMRadioCollection)) {
            String value;
            if (field instanceof SMCheckbox) {
                contentStream.saveGraphicsState();
                Flattener.CheckBoxFieldFlatten(field, contentStream);
                contentStream.restoreGraphicsState();
            } else if (field instanceof SMChoiceField && (value = Flattener.getValue(field)) != null) {
                contentStream.saveGraphicsState();
                Flattener.ChoiceFieldFlatten(field, value, contentStream, formfonts);
                contentStream.restoreGraphicsState();
            }
        }
        List<OMObjectable> kids = field.getKids();
        if (kids != null) {
            int i = 0;
            while (i < kids.size()) {
                Flattener.fieldflatten1((SMField)kids.get(i), contentStream, formfonts);
                ++i;
            }
        }
    }

    static String getValue(SMField field) throws Exception {
        String value = field.getValue();
        if (value == null) {
            value = field.getDefaultValue();
        }
        return value;
    }

    static boolean TextFieldFlatten(SMField field, SMPageContentStream contentStream, Map<String, SMFont> fonts) throws Exception {
        SMAnnotationWidget ann = field.getWidget();
        SMAppearanceDictionary appdict = ann.getAppearance();
        SMRectangle rectarray = ann.getRectangle();
        if (rectarray != null) {
            contentStream.concatenate2CTM(1.0, 0.0, 0.0, 1.0, rectarray.getLowerLeftX(), rectarray.getLowerLeftY());
        }
        OMDictionary app = null;
        OMBase n = null;
        OMStream stream = null;
        if (appdict != null) {
            app = appdict.getDictionary();
        }
        if (app != null) {
            n = app.getDictionaryObject(OMName.N);
        }
        if (n != null) {
            stream = (OMStream)n;
        }
        if (stream != null) {
            Flattener.addStream2Content(stream, contentStream, fonts);
            return true;
        }
        return false;
    }

    static boolean ChoiceFieldFlatten(SMField field, String value, SMPageContentStream contentStream, Map<String, SMFont> fonts) throws Exception {
        SMAnnotationWidget ann = field.getWidget();
        SMAppearanceDictionary appdict = ann.getAppearance();
        if (appdict != null) {
            Map<String, SMAppearanceStream> apmap;
            SMAppearanceStream aps;
            SMRectangle rectarray = ann.getRectangle();
            if (rectarray != null) {
                contentStream.concatenate2CTM(1.0, 0.0, 0.0, 1.0, rectarray.getLowerLeftX(), rectarray.getLowerLeftY());
            }
            if ((aps = (apmap = appdict.getNormalAppearance()).get(value)) != null) {
                OMStream stream = aps.getStream();
                if (stream != null) {
                    Flattener.addStream2Content(stream, contentStream, formfonts);
                    return true;
                }
            } else {
                OMStream streamDef;
                SMAppearanceStream apsDef;
                String defValue = field.getDefaultValue();
                if (defValue != null && defValue.equals(value) && (apsDef = apmap.get("default")) != null && (streamDef = apsDef.getStream()) != null) {
                    Flattener.addStream2Content(streamDef, contentStream, formfonts);
                    return true;
                }
            }
        }
        return false;
    }

    static boolean CheckBoxFieldFlatten(SMField field, SMPageContentStream contentStream) throws Exception {
        SMAnnotationWidget ann = field.getWidget();
        SMAppearanceDictionary appdict = ann.getAppearance();
        OMName radioValue = (OMName)field.getDictionary().getDictionaryObject(OMName.AS);
        String value = null;
        if (radioValue != null) {
            value = radioValue.getName();
        }
        if (appdict != null) {
            OMStream stream;
            Map<String, SMAppearanceStream> apmap;
            SMAppearanceStream aps;
            SMRectangle rectarray = ann.getRectangle();
            if (rectarray != null) {
                contentStream.concatenate2CTM(1.0, 0.0, 0.0, 1.0, rectarray.getLowerLeftX(), rectarray.getLowerLeftY());
            }
            if ((aps = (apmap = appdict.getNormalAppearance()).get(value)) == null && (value == null || value.equals("No") || value.equals("Off"))) {
                aps = apmap.get("Off");
            }
            if (aps != null && (stream = aps.getStream()) != null) {
                Flattener.addStream2Content(stream, contentStream, formfonts);
                return true;
            }
        }
        return false;
    }

    static void addStream2Content(OMStream appstream, SMPageContentStream contentStream, Map<String, SMFont> formfonts) throws Exception {
        SMXObjectForm xobj = new SMXObjectForm(appstream);
        SMResources res = xobj.getResources();
        OMDictionary nresobj = (OMDictionary)appstream.getDictionaryObject(OMName.RESOURCES);
        if (nresobj != null) {
            SMResources nres = new SMResources(nresobj);
            Map<String, SMFont> fieldfonts = nres.getFonts();
            if (fieldfonts != null) {
                for (String name : fieldfonts.keySet()) {
                    SMFont font = fieldfonts.get(name);
                    res.addFont(font, name);
                }
            } else if (formfonts != null) {
                res.setFonts(formfonts);
            }
        }
        xobj.setResources(res);
        contentStream.drawXObject1x1(xobj);
    }
}

