/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.digsig.PDFSignatureInfo;
import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMDocumentInformation;
import com.plpdf.smmodel.interactive.digitalsignature.SMSignature;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.util.PDFKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VerifySignature {
    private static final String CLASS_NAME = VerifySignature.class.getName();
    static Document xmldoc;
    static Element root;

    private VerifySignature() {
    }

    public static void appendtext(String e, String t) throws Exception {
        if (t != null) {
            Element childElement1 = xmldoc.createElement(e);
            root.appendChild(childElement1);
            childElement1.appendChild(xmldoc.createTextNode(t));
            root.appendChild(xmldoc.createTextNode("\n"));
        }
    }

    public static void verify1(InputStream pdfInputStream, OutputStream outfile, String password, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument document = null;
        try {
            byte[] byteArray = VerifySignature.getbyteArray(pdfInputStream);
            document = SMDocument.load(new ByteArrayInputStream(byteArray));
            if (document.isEncrypted()) {
                document.decrypt(password);
            }
            SMDocumentInformation info = document.getDocumentInformation();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            try {
                docBuilder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new PlpdfException(e);
            }
            xmldoc = docBuilder.newDocument();
            root = xmldoc.createElement("pdf-signature");
            xmldoc.appendChild(root);
            root.appendChild(xmldoc.createTextNode("\n"));
            SMAcroForm form = document.getDocumentCatalog().getAcroForm();
            if (form == null) {
                VerifySignature.appendtext("error", "No Acroform");
            } else {
                ArrayList<PDFSignatureInfo> lpsi = new ArrayList<PDFSignatureInfo>();
                for (SMSignature sig : document.getSignatureDictionaries()) {
                    PDFSignatureInfo psi = new PDFSignatureInfo();
                    lpsi.add(psi);
                    OMDictionary sigDict = sig.getDictionary();
                    OMString contents = (OMString)sigDict.getDictionaryObject(OMName.CONTENTS);
                    Set<Map.Entry<OMName, OMBase>> entries = sigDict.entrySet();
                    for (Map.Entry<OMName, OMBase> entry : entries) {
                        if (entry.getKey().equals(OMName.CONTENTS)) continue;
                        psi.entries.put(entry.getKey().getName(), entry.getValue().toString());
                    }
                    psi.reason = sig.getReason();
                    psi.name = sig.getName();
                    psi.signDate = sig.getSignDate().getTime();
                    psi.subFilter = sig.getSubFilter();
                    psi.contactInfo = sig.getContactInfo();
                    psi.filter = sig.getFilter();
                    psi.location = sig.getLocation();
                    VerifySignature.appendtext("filter", psi.filter);
                    VerifySignature.appendtext("subfilter", psi.subFilter);
                    VerifySignature.appendtext("reason", psi.reason);
                    VerifySignature.appendtext("name", psi.name);
                    VerifySignature.appendtext("signdate", sig.getSignDateString());
                    VerifySignature.appendtext("contactinfo", psi.contactInfo);
                    VerifySignature.appendtext("location", psi.location);
                    byte[] buf = sig.getSignedContent(new ByteArrayInputStream(byteArray));
                    int[] byteRange = sig.getByteRange();
                    if (byteRange.length != 4) {
                        VerifySignature.appendtext("error", "Signature byteRange must have 4 items");
                    } else {
                        long fileLen = pdfInputStream.available();
                        long rangeMax = (long)byteRange[2] + (long)byteRange[3];
                        int contentLen = sigDict.getString(OMName.CONTENTS).length() * 2 + 2;
                        psi.coversWholeDocument = fileLen == rangeMax && byteRange[0] == 0 && byteRange[1] + contentLen == byteRange[2];
                    }
                    String subFilter = sig.getSubFilter();
                    if (subFilter != null) {
                        if (subFilter == "adbe.pkcs7.detached") {
                            VerifySignature.verifyPKCS7(buf, contents, sig, psi);
                            continue;
                        }
                        if (subFilter == "adbe.pkcs7.sha1") {
                            OMString certString = (OMString)sigDict.getDictionaryObject(OMName.CONTENTS);
                            byte[] certData = certString.getBytes();
                            CertificateFactory factory1 = CertificateFactory.getInstance("X.509");
                            ByteArrayInputStream certStream = new ByteArrayInputStream(certData);
                            Collection<? extends Certificate> certs = factory1.generateCertificates(certStream);
                            byte[] hash = MessageDigest.getInstance("SHA1").digest(buf);
                            VerifySignature.verifyPKCS7(hash, contents, sig, psi);
                            break;
                        }
                        if (subFilter == "adbe.x509.rsa_sha1") {
                            OMString certString = (OMString)sigDict.getDictionaryObject(OMName.getPDFName("Cert"));
                            byte[] certData = certString.getBytes();
                            CertificateFactory factory2 = CertificateFactory.getInstance("X.509");
                            ByteArrayInputStream certStream = new ByteArrayInputStream(certData);
                            Collection<? extends Certificate> certs = factory2.generateCertificates(certStream);
                            psi.signatureVerified = "Unable to verify adbe.x509.rsa_sha1 subfilter";
                            VerifySignature.appendtext("error", "Unable to verify adbe.x509.rsa_sha1 subfilter");
                            break;
                        }
                        VerifySignature.appendtext("error", "Unknown certificate type " + subFilter);
                        continue;
                    }
                    VerifySignature.appendtext("error", "Missing subfilter for cert dictionary");
                }
            }
            try {
                TransformerFactory tranFactory = TransformerFactory.newInstance();
                Transformer aTransformer = tranFactory.newTransformer();
                DOMSource src = new DOMSource(xmldoc);
                StreamResult dest = new StreamResult(new OutputStreamWriter(outfile, "UTF-8"));
                aTransformer.transform(src, dest);
            }
            catch (TransformerException e) {
                throw new PlpdfException(e);
            }
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    throw new PlpdfException("FailedToCloseDocument", e);
                }
            }
        }
    }

    private static void verifyPKCS7(byte[] byteArray, OMString contents, SMSignature sig, PDFSignatureInfo psi) throws Exception {
    }

    private static byte[] getbyteArray(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        return baos.toByteArray();
    }

    private static boolean isSelfSigned(X509Certificate cert) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            PublicKey key = cert.getPublicKey();
            cert.verify(key);
            return true;
        }
        catch (SignatureException sigEx) {
            return false;
        }
        catch (InvalidKeyException sigEx) {
            return false;
        }
    }
}

