/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.encoding.WinAnsiEncoding;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.edit.SMPageContentStream;
import com.plpdf.smmodel.encryption.AccessPermission;
import com.plpdf.smmodel.encryption.SMEncryptionDictionary;
import com.plpdf.smmodel.encryption.SecurityHandler;
import com.plpdf.smmodel.encryption.SecurityHandlersManager;
import com.plpdf.smmodel.encryption.StandardProtectionPolicy;
import com.plpdf.smmodel.font.SMType1Font;
import com.plpdf.smmodel.graphics.SMExtendedGraphicsState;
import com.plpdf.util.PDFKey;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class TextWaterMark {
    public static void textWaterMark(InputStream pdfInputStream, OutputStream pdfOutputStream, String message, float topLeftX, float topLeftY, String password, String font, float fontSize, int red, int green, int blue, String encoding, float rotation, float opacity, String reencrypt, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument doc = null;
        AccessPermission ap = null;
        int keylength = 40;
        String algorithm = "RC4";
        boolean rec = reencrypt.equalsIgnoreCase("true");
        try {
            doc = SMDocument.load(pdfInputStream);
            if (doc.isEncrypted()) {
                SMEncryptionDictionary encdict;
                if (rec && (encdict = doc.getEncryptionDictionary()) != null) {
                    SecurityHandler securityHandler = SecurityHandlersManager.getInstance().getSecurityHandler(encdict.getFilter());
                    int p = encdict.getPermissions();
                    ap = new AccessPermission(p);
                    keylength = encdict.getLength();
                    algorithm = securityHandler.getAlgorithm();
                }
                doc.decrypt(password);
            }
            List allPages = doc.getDocumentCatalog().getAllPages();
            SMType1Font smFont = new SMType1Font(font);
            SMExtendedGraphicsState gs = new SMExtendedGraphicsState();
            if (opacity < 1.0f) {
                gs.setNonStrokingAlphaConstant(opacity);
            }
            int i = 0;
            while (i < allPages.size()) {
                SMPage page = (SMPage)allPages.get(i);
                SMPageContentStream cs_before = new SMPageContentStream(doc, page, true, true, true);
                cs_before.saveGraphicsState();
                cs_before.close();
                SMPageContentStream cs_after = new SMPageContentStream(doc, page, true, true);
                cs_after.restoreGraphicsState();
                cs_after.close();
                SMRectangle pageSize = page.findMediaBox();
                float pageheight = pageSize.getHeight();
                float stringWidth = smFont.getStringWidth(message);
                float x = topLeftX == -1.0f ? (pageSize.getWidth() - stringWidth * fontSize / 1000.0f) / 2.0f : (topLeftX == -2.0f ? pageSize.getWidth() - stringWidth * fontSize / 1000.0f : topLeftX);
                float y = topLeftY == -1.0f ? (pageheight - fontSize) / 2.0f : (topLeftY == -2.0f ? 0.0f : pageheight - topLeftY - fontSize);
                SMPageContentStream contentStream = new SMPageContentStream(doc, page, true, true, true);
                contentStream.saveGraphicsState();
                if (opacity < 1.0f) {
                    contentStream.startOpacity(gs.getOMDictionary());
                }
                contentStream.setNonStrokingColor(red, green, blue);
                contentStream.beginText();
                if (encoding != null && !encoding.equalsIgnoreCase("cp1252")) {
                    smFont.setEncodingDiffs(encoding, font);
                }
                if (encoding != null && encoding.equalsIgnoreCase("cp1252")) {
                    smFont.setEncoding(new WinAnsiEncoding());
                }
                contentStream.setFont(smFont, fontSize);
                contentStream.moveTextPositionByAmount(x, y);
                if (rotation == 0.0f) {
                    if (encoding != null) {
                        contentStream.drawString(message, encoding);
                    } else {
                        contentStream.drawString(message);
                    }
                } else {
                    double alpha = (double)rotation * Math.PI / 180.0;
                    float cos = (float)Math.cos(alpha);
                    float sin = (float)Math.sin(alpha);
                    float len = stringWidth * fontSize / 1000.0f / 2.0f;
                    float xpos = topLeftX + len - len * cos;
                    float ypos = topLeftY - len * sin;
                    contentStream.setTextMatrix(cos, sin, -sin, cos, xpos, ypos);
                    if (encoding != null) {
                        contentStream.drawString(message, encoding);
                    } else {
                        contentStream.drawString(message);
                    }
                    contentStream.setTextMatrix(0.0f, 0.0f);
                }
                contentStream.endText();
                if (opacity < 1.0f) {
                    contentStream.endOpacity();
                }
                contentStream.restoreGraphicsState();
                contentStream.close();
                ++i;
            }
            if (rec) {
                StandardProtectionPolicy spp = new StandardProtectionPolicy(password, null, ap);
                spp.setEncryptionKeyLength(keylength);
                spp.setAlgorithm(algorithm);
                doc.protect(spp);
            }
            doc.save(pdfOutputStream);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }
}

