/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.encoding.WinAnsiEncoding;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.edit.SMPageContentStream;
import com.plpdf.smmodel.font.SMSimpleFont;
import com.plpdf.smmodel.font.SMTrueTypeFont;
import com.plpdf.smmodel.font.SMType1Font;
import com.plpdf.smmodel.graphics.SMExtendedGraphicsState;
import com.plpdf.util.PDFKey;
import com.plpdf.util.PageCalc;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class TextStamp {
    public static void textStamp(InputStream pdfInputStream, OutputStream pdfOutputStream, String message, float topLeftX, float topLeftY, String password, String fontType, String font, InputStream ttfInputStream, float fontSize, int red, int green, int blue, String encoding, int startPage, int endPage, int rotation, float opacity, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument doc = null;
        try {
            doc = SMDocument.load(pdfInputStream);
            if (doc.isEncrypted()) {
                doc.decrypt(password);
            }
            List allPages = doc.getDocumentCatalog().getAllPages();
            SMSimpleFont smFont = fontType.equalsIgnoreCase("TYPE1") ? new SMType1Font(font) : SMTrueTypeFont.loadTTF(doc, ttfInputStream);
            int[] r = PageCalc.calcNums(startPage, endPage, allPages.size());
            startPage = r[0];
            endPage = r[1];
            SMExtendedGraphicsState gs = new SMExtendedGraphicsState();
            if (opacity < 1.0f) {
                gs.setNonStrokingAlphaConstant(opacity);
            }
            int i = startPage - 1;
            while (i < endPage && i < allPages.size()) {
                SMPage page = (SMPage)allPages.get(i);
                SMPageContentStream cs_before = new SMPageContentStream(doc, page, true, true, true);
                cs_before.saveGraphicsState();
                cs_before.close();
                SMPageContentStream cs_after = new SMPageContentStream(doc, page, true, true);
                cs_after.restoreGraphicsState();
                cs_after.close();
                SMRectangle pageSize = page.findMediaBox();
                float pageheight = pageSize.getHeight();
                float stringWidth = smFont.getStringWidth(message);
                float x = topLeftX == -1.0f ? (pageSize.getWidth() - stringWidth * fontSize / 1000.0f) / 2.0f : (topLeftX == -2.0f ? pageSize.getWidth() - stringWidth * fontSize / 1000.0f : topLeftX);
                float y = topLeftY == -1.0f ? (pageheight - fontSize) / 2.0f : (topLeftY == -2.0f ? 0.0f : pageheight - topLeftY - fontSize);
                SMPageContentStream contentStream = new SMPageContentStream(doc, page, true, true);
                contentStream.saveGraphicsState();
                if (opacity < 1.0f) {
                    contentStream.startOpacity(gs.getOMDictionary());
                }
                contentStream.setNonStrokingColor(red, green, blue);
                contentStream.beginText();
                if (fontType.equalsIgnoreCase("TYPE1")) {
                    if (encoding != null && !encoding.equalsIgnoreCase("cp1252")) {
                        smFont.setEncodingDiffs(encoding, font);
                    }
                    if (encoding != null && encoding.equalsIgnoreCase("cp1252")) {
                        smFont.setEncoding(new WinAnsiEncoding());
                    }
                }
                contentStream.setFont(smFont, fontSize);
                contentStream.moveTextPositionByAmount(x, y);
                if (rotation == 0) {
                    if (encoding != null) {
                        contentStream.drawString(message, encoding);
                    } else {
                        contentStream.drawString(message);
                    }
                } else {
                    double alpha = (double)rotation * Math.PI / 180.0;
                    float cos = (float)Math.cos(alpha);
                    float sin = (float)Math.sin(alpha);
                    float len = stringWidth * fontSize / 1000.0f / 2.0f;
                    float xpos = x + len - len * cos;
                    float ypos = y - len * sin;
                    contentStream.setTextMatrix(cos, sin, -sin, cos, xpos, ypos);
                    if (encoding != null) {
                        contentStream.drawString(message, encoding);
                    } else {
                        contentStream.drawString(message);
                    }
                    contentStream.setTextMatrix(0.0f, 0.0f);
                }
                contentStream.endText();
                if (opacity < 1.0f) {
                    contentStream.endOpacity();
                }
                contentStream.restoreGraphicsState();
                contentStream.close();
                ++i;
            }
            doc.save(pdfOutputStream);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }
}

