/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMStream;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.graphics.xobject.SMXObjectImage;
import com.plpdf.util.PDFKey;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class SetImageCompress {
    private static final String CLASS_NAME = SetImageCompress.class.getName();

    private SetImageCompress() {
    }

    public static void setCompressionQuality(InputStream pdfInputStream, OutputStream pdfOutputStream, float compress, String password, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument doc = null;
        try {
            doc = SMDocument.load(pdfInputStream);
            if (doc.isEncrypted()) {
                doc.decrypt(password);
            }
            List pages = doc.getDocumentCatalog().getAllPages();
            for (SMPage page : pages) {
                SMResources resources = page.getResources();
                Map<String, SMXObjectImage> images = resources.getImages();
                if (images == null) continue;
                for (String key : images.keySet()) {
                    SMXObjectImage image = images.get(key);
                    if (!image.getSuffix().equalsIgnoreCase("jpeg")) continue;
                    try {
                        BufferedImage bi = image.getRGBImage();
                        Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix(image.getSuffix());
                        if (!writers.hasNext()) continue;
                        ImageWriter writer = writers.next();
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        ImageOutputStream ios = ImageIO.createImageOutputStream(out);
                        writer.setOutput(ios);
                        ImageWriteParam param = writer.getDefaultWriteParam();
                        param.setCompressionMode(2);
                        param.setCompressionQuality(compress);
                        writer.write(null, new IIOImage(bi, null, null), param);
                        ByteArrayInputStream ba = new ByteArrayInputStream(out.toByteArray());
                        OMStream oms = image.getOMStream();
                        OutputStream output = null;
                        try {
                            output = oms.createFilteredStream();
                            byte[] buffer = new byte[1024];
                            int amountRead = -1;
                            while ((amountRead = ba.read(buffer)) != -1) {
                                output.write(buffer, 0, amountRead);
                            }
                        }
                        finally {
                            if (output != null) {
                                output.close();
                            }
                        }
                    }
                    catch (UnsupportedOperationException e) {
                        throw new PlpdfException("UnsupportedOperationException", e);
                    }
                }
            }
            doc.save(pdfOutputStream);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }
}

