/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.edit.SMPageContentStream;
import com.plpdf.smmodel.interactive.annotation.SMAnnotation;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationRubberStamp;
import com.plpdf.util.PDFKey;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class RubberStamp {
    private RubberStamp() {
    }

    public static void rubberStamp(InputStream pdfInputStream, OutputStream pdfOutputStream, String contents, int width, int height, int topLeftX, int topLeftY, String rubberStampName, String password, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument doc = SMDocument.load(pdfInputStream);
        if (doc.isEncrypted()) {
            doc.decrypt(password);
        }
        ArrayList allpages = new ArrayList();
        doc.getDocumentCatalog().getPages().getAllKids(allpages);
        int i = 0;
        while (i < allpages.size()) {
            SMPage page = (SMPage)allpages.get(i);
            SMPageContentStream cs_before = new SMPageContentStream(doc, page, true, true, true);
            cs_before.saveGraphicsState();
            cs_before.close();
            SMPageContentStream cs_after = new SMPageContentStream(doc, page, true, true);
            cs_after.restoreGraphicsState();
            cs_after.close();
            SMRectangle pageSize = page.findMediaBox();
            float pageheight = pageSize.getHeight();
            List<SMAnnotation> annotations = page.getAnnotations();
            SMAnnotationRubberStamp rs = new SMAnnotationRubberStamp();
            rs.setName(rubberStampName);
            SMRectangle rectangle = new SMRectangle(width, height);
            rectangle.setLowerLeftX(topLeftX);
            rectangle.setLowerLeftY(pageheight - (float)topLeftY - (float)height);
            rs.setRectangle(rectangle);
            rs.setContents(contents);
            annotations.add(rs);
            ++i;
        }
        doc.save(pdfOutputStream);
        doc.close();
    }
}

