/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.interactive.action.type.SMAction;
import com.plpdf.smmodel.interactive.action.type.SMActionURI;
import com.plpdf.smmodel.interactive.annotation.SMAnnotation;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationLink;
import com.plpdf.util.PDFKey;
import com.plpdf.xmp2.xmp.XMLUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReplaceUrlsXML {
    private ReplaceUrlsXML() {
    }

    public static void replaceUrlsXml(InputStream pdfInputStream, OutputStream pdfOutputStream, InputStream xmlInputStream, String password, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument doc = SMDocument.load(pdfInputStream);
        if (doc.isEncrypted()) {
            doc.decrypt(password);
        }
        List allPages = doc.getDocumentCatalog().getAllPages();
        Document xmldoc = XMLUtil.parse(xmlInputStream);
        Node root = xmldoc.getFirstChild();
        NodeList nodelist = root.getChildNodes();
        int i = 0;
        while (i < nodelist.getLength()) {
            Node tmp_node = nodelist.item(i);
            NamedNodeMap map = tmp_node.getAttributes();
            int k = 0;
            while (k < allPages.size()) {
                SMPage page = (SMPage)allPages.get(k);
                List<SMAnnotation> annotations = page.getAnnotations();
                int j = 0;
                while (j < annotations.size()) {
                    SMActionURI uri;
                    SMAnnotationLink link;
                    SMAction action;
                    SMAnnotation annot = annotations.get(j);
                    if (annot instanceof SMAnnotationLink && (action = (link = (SMAnnotationLink)annot).getAction()) instanceof SMActionURI && (uri = (SMActionURI)action).getURI().equalsIgnoreCase(map.item(0).getNodeValue())) {
                        uri.setURI(map.item(1).getNodeValue());
                    }
                    ++j;
                }
                ++k;
            }
            ++i;
        }
        doc.save(pdfOutputStream);
    }
}

