/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.interactive.action.type.SMAction;
import com.plpdf.smmodel.interactive.action.type.SMActionURI;
import com.plpdf.smmodel.interactive.annotation.SMAnnotation;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationLink;
import com.plpdf.util.PDFKey;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class ReplaceURL {
    public static void replaceUrl(InputStream pdfInputStream, OutputStream pdfOutputStream, String oldURI, String newURI, String password, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument doc = null;
        try {
            doc = SMDocument.load(pdfInputStream);
            if (doc.isEncrypted()) {
                doc.decrypt(password);
            }
            List allPages = doc.getDocumentCatalog().getAllPages();
            int i = 0;
            while (i < allPages.size()) {
                SMPage page = (SMPage)allPages.get(i);
                List<SMAnnotation> annotations = page.getAnnotations();
                int j = 0;
                while (j < annotations.size()) {
                    SMActionURI uri;
                    SMAnnotationLink link;
                    SMAction action;
                    SMAnnotation annot = annotations.get(j);
                    if (annot instanceof SMAnnotationLink && (action = (link = (SMAnnotationLink)annot).getAction()) instanceof SMActionURI && (uri = (SMActionURI)action).getURI().equalsIgnoreCase(oldURI)) {
                        uri.setURI(newURI);
                    }
                    ++j;
                }
                ++i;
            }
            doc.save(pdfOutputStream);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }
}

