/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMString;
import com.plpdf.pdfparser.PDFStreamParser;
import com.plpdf.pdfwriter.ContentStreamWriter;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.util.PDFKey;
import com.plpdf.util.PDFOperator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class ReplaceString {
    private ReplaceString() {
    }

    public static void replaceString(InputStream pdfInputStream, OutputStream pdfOutputStream, String stringToFind, String message, String password, String certKey) throws IOException, Exception {
        PDFKey.toVal(certKey);
        SMDocument doc = null;
        try {
            doc = SMDocument.load(pdfInputStream);
            if (doc.isEncrypted()) {
                doc.decrypt(password);
            }
            List pages = doc.getDocumentCatalog().getAllPages();
            int i = 0;
            while (i < pages.size()) {
                SMPage page = (SMPage)pages.get(i);
                SMStream contents = page.getContents();
                PDFStreamParser parser = new PDFStreamParser(contents.getStream());
                parser.parse();
                List<Object> tokens = parser.getTokens();
                int j = 0;
                while (j < tokens.size()) {
                    Object next = tokens.get(j);
                    if (next instanceof PDFOperator) {
                        OMBase previous;
                        PDFOperator op = (PDFOperator)next;
                        if (op.getOperation().equals("Tj")) {
                            previous = (OMString)tokens.get(j - 1);
                            String string = ((OMString)previous).getString();
                            string = string.replaceFirst(stringToFind, message);
                            ((OMString)previous).reset();
                            ((OMString)previous).append(string.getBytes());
                        } else if (op.getOperation().equals("TJ")) {
                            previous = (OMArray)tokens.get(j - 1);
                            int k = 0;
                            while (k < ((OMArray)previous).size()) {
                                OMBase arrElement = ((OMArray)previous).getObject(k);
                                if (arrElement instanceof OMString) {
                                    OMString omString = (OMString)arrElement;
                                    String string = omString.getString();
                                    string = string.replaceFirst(stringToFind, message);
                                    omString.reset();
                                    omString.append(string.getBytes());
                                }
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
                SMStream updatedStream = new SMStream(doc);
                OutputStream out = updatedStream.createOutputStream();
                ContentStreamWriter tokenWriter = new ContentStreamWriter(out);
                tokenWriter.writeTokens(tokens);
                page.setContents(updatedStream);
                ++i;
            }
            doc.save(pdfOutputStream);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }
}

