/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.encryption.AccessPermission;
import com.plpdf.smmodel.encryption.PublicKeyProtectionPolicy;
import com.plpdf.smmodel.encryption.PublicKeyRecipient;
import com.plpdf.util.PDFKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class PublicKeyEncrypt {
    private static final String CLASS_NAME = PublicKeyEncrypt.class.getName();

    public static void publicKeyEncrypt(InputStream pdfInputStream, OutputStream pdfOutputStream, InputStream publicCert, int keyLength, String canAssemble, String canExtractContent, String canExtractForAccessibility, String canFillInForm, String canModify, String canModifyAnnotations, String canPrint, String canPrintDegraded, String algorithm, String certKey) throws Exception {
        block13: {
            PDFKey.toVal(certKey);
            if (algorithm == "") {
                algorithm = "RC4";
            }
            if (keyLength == 0 && algorithm.equalsIgnoreCase("AES")) {
                keyLength = 128;
            }
            if (keyLength == 0 && algorithm.equalsIgnoreCase("RC4")) {
                keyLength = 40;
            }
            SMDocument document = null;
            AccessPermission ap = new AccessPermission();
            ap.setCanAssembleDocument(canAssemble.equalsIgnoreCase("true"));
            ap.setCanExtractContent(canExtractContent.equalsIgnoreCase("true"));
            ap.setCanExtractForAccessibility(canExtractForAccessibility.equalsIgnoreCase("true"));
            ap.setCanFillInForm(canFillInForm.equalsIgnoreCase("true"));
            ap.setCanModify(canModify.equalsIgnoreCase("true"));
            ap.setCanModifyAnnotations(canModifyAnnotations.equalsIgnoreCase("true"));
            ap.setCanPrint(canPrint.equalsIgnoreCase("true"));
            ap.setCanPrintDegraded(canPrintDegraded.equalsIgnoreCase("true"));
            try {
                document = SMDocument.load(pdfInputStream);
                if (!document.isEncrypted()) {
                    if (algorithm.equalsIgnoreCase("AES") && document.getDocument().getVersion() < 1.6f) {
                        document.setVersion(1.6f);
                    }
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate certificate = (X509Certificate)cf.generateCertificate(publicCert);
                    publicCert.close();
                    PublicKeyProtectionPolicy pkpp = new PublicKeyProtectionPolicy();
                    pkpp.setEncryptionKeyLength(keyLength);
                    pkpp.setAlgorithm(algorithm);
                    PublicKeyRecipient pkRecip = new PublicKeyRecipient();
                    pkRecip.setPermission(ap);
                    pkRecip.setX509(certificate);
                    pkpp.addRecipient(pkRecip);
                    document.protect(pkpp);
                    document.save(pdfOutputStream);
                    break block13;
                }
                throw new PlpdfException(CLASS_NAME, "DocumentAlreadyEncrypted");
            }
            finally {
                if (document != null) {
                    try {
                        document.close();
                    }
                    catch (IOException e) {
                        throw new PlpdfException("FailedToCloseDocument", e);
                    }
                }
            }
        }
    }
}

