/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.encryption.AccessPermission;
import com.plpdf.smmodel.encryption.PublicKeyDecryptionMaterial;
import com.plpdf.util.PDFKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;

public class PublicKeyDecrypt {
    private static final String CLASS_NAME = PublicKeyDecrypt.class.getName();

    public static void publicKeyDecrypt(InputStream pdfInputStream, OutputStream pdfOutputStream, InputStream privateCert, String password, String certKey) throws Exception {
        block10: {
            PDFKey.toVal(certKey);
            SMDocument document = null;
            try {
                document = SMDocument.load(pdfInputStream);
                if (document.isEncrypted()) {
                    KeyStore ks = KeyStore.getInstance("PKCS12");
                    ks.load(privateCert, password.toCharArray());
                    PublicKeyDecryptionMaterial pkdm = new PublicKeyDecryptionMaterial(ks, null, password);
                    document.openProtection(pkdm);
                    AccessPermission ap = document.getCurrentAccessPermission();
                    if (ap.isOwnerPermission()) {
                        document.save(pdfOutputStream);
                        break block10;
                    }
                    throw new PlpdfException(CLASS_NAME, "NotOwner");
                }
                throw new PlpdfException(CLASS_NAME, "DocumentNotEncrypted");
            }
            finally {
                if (document != null) {
                    try {
                        document.close();
                    }
                    catch (IOException e) {
                        throw new PlpdfException("FailedToCloseDocument", e);
                    }
                }
            }
        }
    }
}

