/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.interactive.action.type.SMAction;
import com.plpdf.smmodel.interactive.action.type.SMActionURI;
import com.plpdf.smmodel.interactive.annotation.SMAnnotation;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationLink;
import com.plpdf.util.PDFKey;
import com.plpdf.util.PDFTextStripperByArea;
import java.awt.geom.Rectangle2D;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PrintURLs {
    public static void printURLs(InputStream pdfInputStream, OutputStream outfile, String password, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document xmldoc = docBuilder.newDocument();
        Element root = xmldoc.createElement("pdf-urls");
        xmldoc.appendChild(root);
        try {
            doc = SMDocument.load(pdfInputStream);
            if (doc.isEncrypted()) {
                doc.decrypt(password);
            }
            List allPages = doc.getDocumentCatalog().getAllPages();
            int i = 0;
            while (i < allPages.size()) {
                SMAnnotationLink link;
                SMAnnotation annot;
                PDFTextStripperByArea stripper = new PDFTextStripperByArea();
                SMPage page = (SMPage)allPages.get(i);
                List<SMAnnotation> annotations = page.getAnnotations();
                int j = 0;
                while (j < annotations.size()) {
                    annot = annotations.get(j);
                    if (annot instanceof SMAnnotationLink) {
                        link = (SMAnnotationLink)annot;
                        SMRectangle rect = link.getRectangle();
                        float x = rect.getLowerLeftX();
                        float y = rect.getUpperRightY();
                        float width = rect.getWidth();
                        float height = rect.getHeight();
                        int rotation = page.findRotation();
                        if (rotation == 0) {
                            SMRectangle pageSize = page.findMediaBox();
                            y = pageSize.getHeight() - y;
                        }
                        Rectangle2D.Float awtRect = new Rectangle2D.Float(x, y, width, height);
                        stripper.addRegion("" + j, awtRect);
                    }
                    ++j;
                }
                stripper.extractRegions(page);
                j = 0;
                while (j < annotations.size()) {
                    SMAction action;
                    annot = annotations.get(j);
                    if (annot instanceof SMAnnotationLink && (action = (link = (SMAnnotationLink)annot).getAction()) instanceof SMActionURI) {
                        SMActionURI uri = (SMActionURI)action;
                        String url = uri.getURI();
                        Element childElement1 = xmldoc.createElement("url");
                        childElement1.setAttribute("url", url);
                        root.appendChild(childElement1);
                    }
                    ++j;
                }
                ++i;
            }
        }
        finally {
            if (doc != null) {
                doc.close();
            }
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer aTransformer = tranFactory.newTransformer();
            DOMSource src = new DOMSource(xmldoc);
            StreamResult dest = new StreamResult(new OutputStreamWriter(outfile, "UTF-8"));
            aTransformer.transform(src, dest);
        }
    }
}

