/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.smmodel.SMDocument;
import com.plpdf.util.PDFKey;
import com.plpdf.util.PDFMergerUtility;
import java.io.InputStream;
import java.io.OutputStream;

public class PDFMerger {
    private PDFMerger() {
    }

    public static void merge(InputStream pdfInputStream1, InputStream pdfInputStream2, String password1, String password2, OutputStream pdfOutputStream, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument inputdoc1 = null;
        SMDocument inputdoc2 = null;
        try {
            inputdoc1 = SMDocument.load(pdfInputStream1);
            inputdoc2 = SMDocument.load(pdfInputStream2);
            if (inputdoc1.isEncrypted()) {
                inputdoc1.decrypt(password1);
            }
            if (inputdoc2.isEncrypted()) {
                inputdoc2.decrypt(password2);
            }
            inputdoc1.CopyResourcesIntoPage();
            inputdoc2.CopyResourcesIntoPage();
            PDFMergerUtility merger = new PDFMergerUtility();
            merger.mergeDocuments(inputdoc1, inputdoc2, pdfOutputStream);
        }
        finally {
            if (inputdoc1 != null) {
                inputdoc1.close();
            }
            if (inputdoc2 != null) {
                inputdoc2.close();
            }
        }
    }
}

