/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.edit.SMPageContentStream;
import com.plpdf.smmodel.graphics.xobject.SMXObjectForm;
import com.plpdf.util.PDFKey;
import com.plpdf.util.PDFMergerUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class Overlay2 {
    private static final String CLASS_NAME = Overlay2.class.getName();

    public static void overlay(InputStream pdfInputStream, InputStream pdfOverlayInputStream, OutputStream pdfOutputStream, String overlayPassword, String pdfPassword, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument overlay = null;
        SMDocument pdf = null;
        try {
            pdf = SMDocument.load(pdfInputStream);
            if (pdf.isEncrypted()) {
                pdf.decrypt(pdfPassword);
            }
            if ((overlay = SMDocument.load(pdfOverlayInputStream)).isEncrypted()) {
                overlay.decrypt(overlayPassword);
            }
            pdf.CopyResourcesIntoPage();
            overlay.CopyResourcesIntoPage();
            Overlay2 overlayer = new Overlay2();
            overlayer.overlayproc(overlay, pdf);
            pdf.save(pdfOutputStream);
        }
        finally {
            if (overlay != null) {
                overlay.close();
            }
            if (pdf != null) {
                pdf.close();
            }
        }
    }

    public SMDocument overlayproc(SMDocument overlay, SMDocument destination) throws IOException, PlpdfException {
        SMPage page;
        if (overlay.getDocument().getVersion() > destination.getDocument().getVersion()) {
            destination.setVersion(1.4f);
        }
        PDFMergerUtility.PagesRotateIntoPage(overlay);
        PDFMergerUtility.PagesRotateIntoPage(destination);
        SMXObjectForm xpage = null;
        ArrayList<SMXObjectForm> xpages = new ArrayList<SMXObjectForm>();
        int i = 0;
        while (i < overlay.getNumberOfPages()) {
            page = (SMPage)overlay.getDocumentCatalog().getAllPages().get(i);
            byte[] b = page.getContents().getByteArray();
            xpage = new SMXObjectForm(new SMStream(destination, b, true));
            xpage.setFormType(1);
            xpage.setResources(page.getResources());
            xpage.setBBox(page.findMediaBox());
            xpages.add(i, xpage);
            ++i;
        }
        i = 0;
        while (i < destination.getNumberOfPages()) {
            page = (SMPage)destination.getDocumentCatalog().getAllPages().get(i);
            SMPageContentStream contentStream = new SMPageContentStream(destination, page, true, true, true);
            contentStream.saveGraphicsState();
            int layoutPageNum = i % xpages.size();
            SMXObjectForm xpage1 = (SMXObjectForm)xpages.get(layoutPageNum);
            contentStream.drawXObject1x1(xpage1);
            contentStream.restoreGraphicsState();
            contentStream.close();
            ++i;
        }
        return destination;
    }
}

