/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.pdfparser.PDFParser;
import com.plpdf.pdfwriter.OMWriter;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMDocumentCatalog;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.SMResources;
import com.plpdf.util.PDFKey;
import com.plpdf.util.PDFMergerUtility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Overlay {
    private static final String CLASS_NAME = Overlay.class.getName();
    public static final OMName XOBJECT = OMName.getPDFName("XObject");
    public static final OMName PROC_SET = OMName.getPDFName("ProcSet");
    public static final OMName EXT_G_STATE = OMName.getPDFName("ExtGState");
    private List layoutPages = new ArrayList(10);
    private SMDocument pdfOverlay;
    private SMDocument pdfDocument = null;
    private int pageCount = 0;
    private OMStream saveGraphicsStateStream;
    private OMStream restoreGraphicsStateStream;

    public static void overlay_nouse(InputStream pdfInputStream, InputStream pdfOverlayInputStream, OutputStream pdfOutputStream, String overlayPassword, String pdfPassword, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument overlay = null;
        SMDocument pdf = null;
        try {
            overlay = Overlay.getDocument(pdfOverlayInputStream);
            pdf = Overlay.getDocument(pdfInputStream);
            if (overlay.isEncrypted()) {
                overlay.decrypt(overlayPassword);
            }
            if (pdf.isEncrypted()) {
                pdf.decrypt(pdfPassword);
            }
            pdf.CopyResourcesIntoPage();
            overlay.CopyResourcesIntoPage();
            Overlay overlayer = new Overlay();
            overlayer.overlay(overlay, pdf);
            Overlay.writeDocument(pdf, pdfOutputStream);
        }
        finally {
            if (overlay != null) {
                overlay.close();
            }
            if (pdf != null) {
                pdf.close();
            }
        }
    }

    private static void writeDocument(SMDocument pdf, OutputStream pdfOutputStream) throws Exception {
        OMWriter writer = null;
        try {
            writer = new OMWriter(pdfOutputStream);
            writer.write(pdf);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (pdfOutputStream != null) {
                pdfOutputStream.close();
            }
        }
    }

    private static SMDocument getDocument(InputStream pdfInputStream) throws Exception {
        PDFParser parser = null;
        SMDocument result = null;
        try {
            parser = new PDFParser(pdfInputStream);
            parser.parse();
            result = parser.getSMDocument();
        }
        finally {
            if (pdfInputStream != null) {
                pdfInputStream.close();
            }
        }
        return result;
    }

    public SMDocument overlay(SMDocument overlay, SMDocument destination) throws IOException, PlpdfException {
        this.pdfOverlay = overlay;
        this.pdfDocument = destination;
        if (overlay.getDocument().getVersion() > destination.getDocument().getVersion()) {
            destination.setVersion(1.4f);
        }
        PDFMergerUtility.PagesRotateIntoPage(overlay);
        PDFMergerUtility.PagesRotateIntoPage(destination);
        SMDocumentCatalog overlayCatalog = this.pdfOverlay.getDocumentCatalog();
        this.collectLayoutPages(overlayCatalog.getAllPages());
        OMDictionary saveGraphicsStateDic = new OMDictionary();
        this.saveGraphicsStateStream = new OMStream(saveGraphicsStateDic, this.pdfDocument.getDocument().getScratchFile());
        OutputStream saveStream = this.saveGraphicsStateStream.createUnfilteredStream();
        saveStream.write(" q\n".getBytes());
        saveStream.flush();
        this.restoreGraphicsStateStream = new OMStream(saveGraphicsStateDic, this.pdfDocument.getDocument().getScratchFile());
        OutputStream restoreStream = this.restoreGraphicsStateStream.createUnfilteredStream();
        restoreStream.write(" Q\n".getBytes());
        restoreStream.flush();
        SMDocumentCatalog pdfCatalog = this.pdfDocument.getDocumentCatalog();
        this.processPages(pdfCatalog.getAllPages());
        return this.pdfDocument;
    }

    private void collectLayoutPages(List pages) throws IOException, PlpdfException {
        for (SMPage page : pages) {
            OMBase contents = page.getOMDictionary().getDictionaryObject(OMName.CONTENTS);
            SMResources resources = page.findResources();
            if (resources == null) {
                resources = new SMResources();
                page.setResources(resources);
            }
            OMDictionary res = resources.getOMDictionary();
            if (contents instanceof OMStream) {
                OMStream stream = (OMStream)contents;
                TreeMap objectNameMap = new TreeMap();
                stream = this.makeUniqueObjectNames(objectNameMap, stream);
                this.layoutPages.add(new LayoutPage(stream, res, objectNameMap));
                continue;
            }
            if (contents instanceof OMArray) {
                throw new PlpdfException(CLASS_NAME, "OMArrayNotSupported");
            }
            throw new PlpdfException(CLASS_NAME, "UnknownContentsType", new String[]{contents.getClass().getName()});
        }
    }

    private OMStream makeUniqueObjectNames(Map objectNameMap, OMStream stream) throws IOException, PlpdfException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
        byte[] buf = new byte[10240];
        InputStream is = stream.getUnfilteredStream();
        while ((read = is.read(buf)) > -1) {
            baos.write(buf, 0, read);
        }
        buf = baos.toByteArray();
        baos = new ByteArrayOutputStream(buf.length + 100);
        StringBuffer sbObjectName = new StringBuffer(10);
        StringBuffer sName = new StringBuffer(10);
        boolean bInObjectIdent = false;
        boolean bInText = false;
        boolean bInEscape = false;
        boolean bInInlineImage = false;
        int i = 0;
        while (i < buf.length) {
            block17: {
                byte b;
                block18: {
                    block15: {
                        block16: {
                            b = buf[i];
                            if (bInEscape) break block15;
                            if (!bInText && b == 40) {
                                bInText = true;
                            }
                            if (bInText && b == 41) {
                                bInText = false;
                            }
                            if (b == 92) {
                                bInEscape = true;
                            }
                            if (!bInText && !bInEscape) {
                                if (b == 47) {
                                    bInObjectIdent = true;
                                } else if (bInObjectIdent && Character.isWhitespace((char)b)) {
                                    bInObjectIdent = false;
                                    String objectName = sbObjectName.toString().substring(1);
                                    String newObjectName = bInInlineImage ? objectName : String.valueOf(objectName) + "overlay";
                                    baos.write(47);
                                    baos.write(newObjectName.getBytes());
                                    objectNameMap.put(objectName, OMName.getPDFName(newObjectName));
                                    sbObjectName.delete(0, sbObjectName.length());
                                } else if (!bInObjectIdent && Character.isWhitespace((char)b)) {
                                    String sName1 = sName.toString().substring(1);
                                    if (sName1.equalsIgnoreCase("BI")) {
                                        bInInlineImage = true;
                                    } else if (sName1.equalsIgnoreCase("EI")) {
                                        bInInlineImage = false;
                                    }
                                    sName.delete(0, sName.length());
                                }
                            }
                            if (!bInObjectIdent) break block16;
                            sbObjectName.append((char)b);
                            break block17;
                        }
                        if (sName.length() < 10) {
                            sName.append((char)b);
                        }
                        break block18;
                    }
                    bInEscape = false;
                }
                baos.write(b);
            }
            ++i;
        }
        OMDictionary streamDict = new OMDictionary();
        streamDict.setItem(OMName.LENGTH, (OMBase)new OMInteger(baos.size()));
        OMStream output = new OMStream(streamDict, this.pdfDocument.getDocument().getScratchFile());
        output.setFilters(stream.getFilters());
        OutputStream os = output.createUnfilteredStream();
        baos.writeTo(os);
        os.close();
        return output;
    }

    private void processPages(List pages) throws PlpdfException {
        for (SMPage page : pages) {
            OMDictionary pageDictionary = page.getOMDictionary();
            OMBase contents = pageDictionary.getDictionaryObject(OMName.CONTENTS);
            if (contents instanceof OMStream) {
                OMStream contentsStream = (OMStream)contents;
                ++this.pageCount;
                OMArray array = new OMArray();
                array.add(contentsStream);
                this.mergePage(array, page);
                pageDictionary.setItem(OMName.CONTENTS, (OMBase)array);
                continue;
            }
            if (contents instanceof OMArray) {
                OMArray contentsArray = (OMArray)contents;
                this.mergePage(contentsArray, page);
                continue;
            }
            throw new PlpdfException(CLASS_NAME, "UnknownContentsType", new String[]{contents.getClass().getName()});
        }
    }

    private void mergePage(OMArray array, SMPage page) {
        int layoutPageNum = this.pageCount % this.layoutPages.size();
        LayoutPage layoutPage = (LayoutPage)this.layoutPages.get(layoutPageNum);
        SMResources resources = page.findResources();
        if (resources == null) {
            resources = new SMResources();
            page.setResources(resources);
        }
        OMDictionary docResDict = resources.getOMDictionary();
        OMDictionary layoutResDict = layoutPage.res;
        this.mergeArray(PROC_SET, docResDict, layoutResDict);
        this.mergeDictionary(OMName.FONT, docResDict, layoutResDict, layoutPage.objectNameMap);
        this.mergeDictionary(XOBJECT, docResDict, layoutResDict, layoutPage.objectNameMap);
        this.mergeDictionary(EXT_G_STATE, docResDict, layoutResDict, layoutPage.objectNameMap);
        array.add(0, this.saveGraphicsStateStream);
        array.add(this.restoreGraphicsStateStream);
        array.add(0, layoutPage.contents);
    }

    private void mergeDictionary(OMName name, OMDictionary dest, OMDictionary source, Map objectNameMap) {
        OMDictionary destDict = (OMDictionary)dest.getDictionaryObject(name);
        OMDictionary sourceDict = (OMDictionary)source.getDictionaryObject(name);
        if (destDict == null) {
            destDict = new OMDictionary();
            dest.setItem(name, (OMBase)destDict);
        }
        if (sourceDict != null) {
            for (OMName key : sourceDict.keyList()) {
                OMName mappedKey = (OMName)objectNameMap.get(key.getName());
                if (mappedKey == null) continue;
                destDict.setItem(mappedKey, sourceDict.getItem(key));
            }
        }
    }

    private void mergeArray(OMName name, OMDictionary dest, OMDictionary source) {
        OMArray destDict = (OMArray)dest.getDictionaryObject(name);
        OMArray sourceDict = (OMArray)source.getDictionaryObject(name);
        if (destDict == null) {
            destDict = new OMArray();
            dest.setItem(name, (OMBase)destDict);
        }
        int sourceDictIdx = 0;
        while (sourceDict != null && sourceDictIdx < sourceDict.size()) {
            OMBase key = sourceDict.get(sourceDictIdx);
            if (key instanceof OMName) {
                OMName keyname = (OMName)key;
                boolean bFound = false;
                int destDictIdx = 0;
                while (destDictIdx < destDict.size()) {
                    OMName destkeyname;
                    OMBase destkey = destDict.get(destDictIdx);
                    if (destkey instanceof OMName && (destkeyname = (OMName)destkey).equals(keyname)) {
                        bFound = true;
                        break;
                    }
                    ++destDictIdx;
                }
                if (!bFound) {
                    destDict.add(keyname);
                }
            }
            ++sourceDictIdx;
        }
    }

    private static class LayoutPage {
        private final OMBase contents;
        private final OMDictionary res;
        private final Map objectNameMap;

        public LayoutPage(OMBase contentsValue, OMDictionary resValue, Map objectNameMapValue) {
            this.contents = contentsValue;
            this.res = resValue;
            this.objectNameMap = objectNameMapValue;
        }
    }
}

