/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.pdfparser.PDFParser;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMDocumentInformation;
import com.plpdf.util.PDFKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetadataToXML {
    private MetadataToXML() {
    }

    public static void metadataToXml(InputStream pdfInputStream, OutputStream xmlOutputStream, String password, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument document = null;
        try {
            PDFParser parser = new PDFParser(pdfInputStream);
            parser.parse();
            document = parser.getSMDocument();
            if (document.isEncrypted()) {
                document.decrypt(password);
            }
            MetadataToXML.printMetadata(document, xmlOutputStream);
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    private static void printMetadata(SMDocument document, OutputStream outputStream) throws IOException, PlpdfException {
        SMDocumentInformation info = document.getDocumentInformation();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new PlpdfException(e);
        }
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement("pdf-metadata");
        doc.appendChild(root);
        root.appendChild(doc.createTextNode("\n"));
        if (info.getProducer() != null) {
            String tmpproducer = info.getProducer();
            Element childElement1 = doc.createElement("producer");
            root.appendChild(childElement1);
            childElement1.appendChild(doc.createTextNode(tmpproducer));
            root.appendChild(doc.createTextNode("\n"));
        }
        if (info.getCreationDate() != null) {
            String createtime = MetadataToXML.formatDate(info.getCreationDate(), "yyyyMMddHHmmss");
            Element childElement2 = doc.createElement("createtime");
            root.appendChild(childElement2);
            childElement2.appendChild(doc.createTextNode(createtime));
            root.appendChild(doc.createTextNode("\n"));
        }
        if (info.getTitle() != null) {
            String tmptitle = info.getTitle();
            Element childElement3 = doc.createElement("title");
            root.appendChild(childElement3);
            childElement3.appendChild(doc.createTextNode(tmptitle));
            root.appendChild(doc.createTextNode("\n"));
        }
        if (info.getAuthor() != null) {
            String tmpauthor = info.getAuthor();
            Element childElement4 = doc.createElement("author");
            root.appendChild(childElement4);
            childElement4.appendChild(doc.createTextNode(tmpauthor));
            root.appendChild(doc.createTextNode("\n"));
        }
        if (info.getSubject() != null) {
            String tmpsubject = info.getSubject();
            Element childElement5 = doc.createElement("subject");
            root.appendChild(childElement5);
            childElement5.appendChild(doc.createTextNode(tmpsubject));
            root.appendChild(doc.createTextNode("\n"));
        }
        if (info.getKeywords() != null) {
            String tmpkeywords = info.getKeywords();
            Element childElement6 = doc.createElement("keywords");
            root.appendChild(childElement6);
            childElement6.appendChild(doc.createTextNode(tmpkeywords));
        }
        if (info.getCreator() != null) {
            String tmpcreator = info.getCreator();
            Element childElement7 = doc.createElement("creator");
            root.appendChild(childElement7);
            childElement7.appendChild(doc.createTextNode(tmpcreator));
            root.appendChild(doc.createTextNode("\n"));
        }
        if (info.getModificationDate() != null) {
            String tmpmodi = MetadataToXML.formatDate(info.getModificationDate(), "yyyyMMddHHmmss");
            Element childElement8 = doc.createElement("modificationdate");
            root.appendChild(childElement8);
            childElement8.appendChild(doc.createTextNode(tmpmodi));
            root.appendChild(doc.createTextNode("\n"));
        }
        try {
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer aTransformer = tranFactory.newTransformer();
            DOMSource src = new DOMSource(doc);
            StreamResult dest = new StreamResult(new OutputStreamWriter(outputStream, "UTF-8"));
            aTransformer.transform(src, dest);
        }
        catch (TransformerException e) {
            throw new PlpdfException(e);
        }
    }

    private static String formatDate(Calendar date, String pattern) {
        String retval = null;
        if (date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat(pattern);
            retval = formatter.format(date.getTime());
        }
        return retval;
    }
}

