/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMDocumentCatalog;
import com.plpdf.smmodel.SMDocumentInformation;
import com.plpdf.smmodel.common.SMMetadata;
import com.plpdf.util.DateConverter;
import com.plpdf.util.PDFKey;
import com.plpdf.xmp2.xmp.XMLUtil;
import com.plpdf.xmp2.xmp.XMPMetadata;
import java.io.InputStream;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class MetadataFromXML {
    private MetadataFromXML() {
    }

    public static void metadataFromXml(InputStream pdfInputStream, InputStream xmlInputStream, OutputStream pdfOutputStream, String password, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument document = null;
        Document xmldoc = XMLUtil.parse(xmlInputStream);
        Node root = xmldoc.getFirstChild();
        NodeList childs = root.getChildNodes();
        try {
            document = SMDocument.load(pdfInputStream);
            if (document.isEncrypted()) {
                document.decrypt(password);
            }
            SMDocumentCatalog catalog = document.getDocumentCatalog();
            SMDocumentInformation info = document.getDocumentInformation();
            XMPMetadata metadata = new XMPMetadata();
            int i = 0;
            while (i < childs.getLength()) {
                Node tmp_node = childs.item(i);
                if (tmp_node.getNodeType() == 1) {
                    String date;
                    Text a = (Text)tmp_node.getFirstChild();
                    if (tmp_node.getNodeName().equalsIgnoreCase("title")) {
                        info.setTitle(a.getNodeValue());
                    }
                    if (tmp_node.getNodeName().equalsIgnoreCase("author")) {
                        info.setAuthor(a.getNodeValue());
                    }
                    if (tmp_node.getNodeName().equalsIgnoreCase("subject")) {
                        info.setSubject(a.getNodeValue());
                    }
                    if (tmp_node.getNodeName().equalsIgnoreCase("creator")) {
                        info.setCreator(a.getNodeValue());
                    }
                    if (tmp_node.getNodeName().equalsIgnoreCase("keywords")) {
                        info.setKeywords(a.getNodeValue());
                    }
                    if (tmp_node.getNodeName().equalsIgnoreCase("producer")) {
                        info.setProducer(a.getNodeValue());
                    }
                    if (tmp_node.getNodeName().equalsIgnoreCase("createtime")) {
                        date = a.getNodeValue();
                        info.setCreationDate(DateConverter.toCalendar(date));
                    }
                    if (tmp_node.getNodeName().equalsIgnoreCase("modificationdate")) {
                        date = a.getNodeValue();
                        info.setModificationDate(DateConverter.toCalendar(date));
                    }
                }
                ++i;
            }
            SMMetadata metadataStream = new SMMetadata(document);
            metadataStream.importXMPMetadata(metadata);
            catalog.setMetadata(metadataStream);
            document.save(pdfOutputStream);
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }
}

