/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.encryption.AccessPermission;
import com.plpdf.smmodel.encryption.StandardProtectionPolicy;
import com.plpdf.util.PDFKey;
import com.plpdf.util.PDFMergerUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MergeEncrypt {
    private static final String CLASS_NAME = MergeEncrypt.class.getName();

    public static void mergeencrypt(InputStream pdfInputStream1, InputStream pdfInputStream2, String password1, String password2, OutputStream pdfOutputStream, String oPassword, String uPassword, int keyLength, String canAssemble, String canExtractContent, String canExtractForAccessibility, String canFillInForm, String canModify, String canModifyAnnotations, String canPrint, String canPrintDegraded, String algorithm, String certKey) throws Exception {
        block20: {
            PDFKey.toVal(certKey);
            if (algorithm == "") {
                algorithm = "RC4";
            }
            if (algorithm.equalsIgnoreCase("AES") && keyLength == 0) {
                keyLength = 128;
            }
            if (keyLength == 0) {
                keyLength = 40;
            }
            SMDocument document1 = null;
            SMDocument document2 = null;
            AccessPermission ap = new AccessPermission();
            ap.setCanAssembleDocument(canAssemble.equalsIgnoreCase("true"));
            ap.setCanExtractContent(canExtractContent.equalsIgnoreCase("true"));
            ap.setCanExtractForAccessibility(canExtractForAccessibility.equalsIgnoreCase("true"));
            ap.setCanFillInForm(canFillInForm.equalsIgnoreCase("true"));
            ap.setCanModify(canModify.equalsIgnoreCase("true"));
            ap.setCanModifyAnnotations(canModifyAnnotations.equalsIgnoreCase("true"));
            ap.setCanPrint(canPrint.equalsIgnoreCase("true"));
            ap.setCanPrintDegraded(canPrintDegraded.equalsIgnoreCase("true"));
            try {
                document1 = SMDocument.load(pdfInputStream1);
                document2 = SMDocument.load(pdfInputStream2);
                if (document1.isEncrypted()) {
                    document1.decrypt(password1);
                }
                if (document2.isEncrypted()) {
                    document2.decrypt(password2);
                }
                document1.CopyResourcesIntoPage();
                document2.CopyResourcesIntoPage();
                PDFMergerUtility merger = new PDFMergerUtility();
                merger.appendDocument(document1, document2);
                if (algorithm.equalsIgnoreCase("AES") && document1.getDocument().getVersion() < 1.6f) {
                    document1.setVersion(1.6f);
                }
                if (!document1.isEncrypted()) {
                    StandardProtectionPolicy spp = new StandardProtectionPolicy(oPassword, uPassword, ap);
                    spp.setEncryptionKeyLength(keyLength);
                    spp.setAlgorithm(algorithm);
                    document1.protect(spp);
                    document1.save(pdfOutputStream);
                    break block20;
                }
                throw new PlpdfException(CLASS_NAME, "DocumentAlreadyEncrypted");
            }
            finally {
                if (document1 != null) {
                    try {
                        document1.close();
                    }
                    catch (IOException e) {
                        throw new PlpdfException("FailedToCloseDocument", e);
                    }
                }
                if (document2 != null) {
                    try {
                        document2.close();
                    }
                    catch (IOException e) {
                        throw new PlpdfException("FailedToCloseDocument", e);
                    }
                }
            }
        }
    }
}

