/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMBoolean;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMDocumentCatalog;
import com.plpdf.smmodel.fdf.FDFDocument;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.util.PDFKey;
import java.io.InputStream;
import java.io.OutputStream;

public class ImportFDF {
    public static void importFDF(InputStream pdfInputStream, InputStream fdfInputStream, OutputStream pdfOutputStream, String password, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument pdf = null;
        FDFDocument fdf = null;
        try {
            pdf = SMDocument.load(pdfInputStream);
            if (pdf.isEncrypted()) {
                pdf.decrypt(password);
            }
            fdf = FDFDocument.load(fdfInputStream);
            SMDocumentCatalog docCatalog = pdf.getDocumentCatalog();
            SMAcroForm acroForm = docCatalog.getAcroForm();
            acroForm.getDictionary().setItem(OMName.NEEDAPPEARANCES, (OMBase)OMBoolean.TRUE);
            acroForm.getXFA();
            if (!acroForm.isXfaPresent()) {
                acroForm.setCacheFields(true);
            }
            acroForm.importFDF(fdf);
            pdf.save(pdfOutputStream);
        }
        finally {
            if (fdf != null) {
                fdf.close();
            }
            if (pdf != null) {
                pdf.close();
            }
        }
    }
}

