/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.edit.SMPageContentStream;
import com.plpdf.smmodel.graphics.SMExtendedGraphicsState;
import com.plpdf.smmodel.graphics.xobject.SMJpeg;
import com.plpdf.smmodel.graphics.xobject.SMXObjectImage;
import com.plpdf.util.PDFKey;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageWaterMark {
    public static void imageWaterMark(InputStream pdfInputStream, OutputStream pdfOutputStream, InputStream imageInputStream, float topLeftX, float topLeftY, float width, float height, float opacity, String password, String certKey) throws Exception {
        if (pdfInputStream != null) {
            PDFKey.toVal(certKey);
            SMDocument doc = null;
            try {
                doc = SMDocument.load(pdfInputStream);
                if (doc.isEncrypted()) {
                    doc.decrypt(password);
                }
                SMJpeg ximage = null;
                ximage = new SMJpeg(doc, imageInputStream);
                SMExtendedGraphicsState gs = new SMExtendedGraphicsState();
                if (opacity < 1.0f) {
                    gs.setNonStrokingAlphaConstant(opacity);
                }
                int i = 0;
                while (i < doc.getNumberOfPages()) {
                    SMPage page = (SMPage)doc.getDocumentCatalog().getAllPages().get(i);
                    SMPageContentStream cs_before = new SMPageContentStream(doc, page, true, true, true);
                    cs_before.saveGraphicsState();
                    cs_before.close();
                    SMPageContentStream cs_after = new SMPageContentStream(doc, page, true, true);
                    cs_after.restoreGraphicsState();
                    cs_after.close();
                    SMPageContentStream contentStream = new SMPageContentStream(doc, page, true, true, true);
                    contentStream.saveGraphicsState();
                    SMRectangle pageSize = page.findMediaBox();
                    float pageheight = pageSize.getHeight();
                    if (height == -1.0f) {
                        height = ((SMXObjectImage)ximage).getHeight();
                    }
                    if (width == -1.0f) {
                        width = ((SMXObjectImage)ximage).getWidth();
                    }
                    float y = topLeftY == -1.0f ? (pageSize.getHeight() - height) / 2.0f : (topLeftY == -2.0f ? 0.0f : pageheight - topLeftY - height);
                    float x = topLeftX == -1.0f ? (pageSize.getWidth() - width) / 2.0f : (topLeftX == -2.0f ? pageSize.getWidth() - width : topLeftX);
                    if (opacity < 1.0f) {
                        contentStream.startOpacity(gs.getOMDictionary());
                    }
                    if (width == -1.0f && height == -1.0f) {
                        contentStream.drawImage(ximage, x, y);
                    } else {
                        contentStream.drawXObject(ximage, x, y, width, height);
                    }
                    if (opacity < 1.0f) {
                        contentStream.endOpacity();
                    }
                    contentStream.restoreGraphicsState();
                    contentStream.close();
                    ++i;
                }
                doc.save(pdfOutputStream);
            }
            finally {
                if (doc != null) {
                    doc.close();
                }
            }
        }
    }
}

