/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.encoding.WinAnsiEncoding;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.edit.SMPageContentStream;
import com.plpdf.smmodel.font.SMSimpleFont;
import com.plpdf.smmodel.font.SMTrueTypeFont;
import com.plpdf.smmodel.font.SMType1Font;
import com.plpdf.smmodel.graphics.SMExtendedGraphicsState;
import com.plpdf.smmodel.graphics.xobject.SMJpeg;
import com.plpdf.smmodel.graphics.xobject.SMXObjectImage;
import com.plpdf.util.PDFKey;
import com.plpdf.util.PDFMergerUtility;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageStamp {
    public static void imageStamp(InputStream pdfInputStream, OutputStream pdfOutputStream, InputStream imageInputStream, float topLeftX, float topLeftY, float width, float height, float opacity, String password, String certKey) throws Exception {
        if (pdfInputStream != null) {
            PDFKey.toVal(certKey);
            SMDocument doc = null;
            try {
                doc = SMDocument.load(pdfInputStream);
                if (doc.isEncrypted()) {
                    doc.decrypt(password);
                }
                doc.CopyResourcesIntoPage();
                SMJpeg ximage = null;
                ximage = new SMJpeg(doc, imageInputStream);
                SMExtendedGraphicsState gs = new SMExtendedGraphicsState();
                if (opacity < 1.0f) {
                    gs.setNonStrokingAlphaConstant(opacity);
                }
                int i = 0;
                while (i < doc.getNumberOfPages()) {
                    SMPage page = (SMPage)doc.getDocumentCatalog().getAllPages().get(i);
                    SMPageContentStream cs_before = new SMPageContentStream(doc, page, true, true, true);
                    cs_before.saveGraphicsState();
                    cs_before.close();
                    SMPageContentStream cs_after = new SMPageContentStream(doc, page, true, true);
                    cs_after.restoreGraphicsState();
                    cs_after.close();
                    SMPageContentStream contentStream = new SMPageContentStream(doc, page, true, true);
                    contentStream.saveGraphicsState();
                    SMRectangle pageSize = page.findMediaBox();
                    float pageheight = pageSize.getHeight();
                    if (height == -1.0f) {
                        height = ((SMXObjectImage)ximage).getHeight();
                    }
                    if (width == -1.0f) {
                        width = ((SMXObjectImage)ximage).getWidth();
                    }
                    float y = topLeftY == -1.0f ? (pageSize.getHeight() - height) / 2.0f : (topLeftY == -2.0f ? 0.0f : pageheight - topLeftY - height);
                    float x = topLeftX == -1.0f ? (pageSize.getWidth() - width) / 2.0f : (topLeftX == -2.0f ? pageSize.getWidth() - width : topLeftX);
                    if (opacity < 1.0f) {
                        contentStream.startOpacity(gs.getOMDictionary());
                    }
                    if (width == -1.0f && height == -1.0f) {
                        contentStream.drawImage(ximage, x, y);
                    } else {
                        contentStream.drawXObject(ximage, x, y, width, height);
                    }
                    if (opacity < 1.0f) {
                        contentStream.endOpacity();
                    }
                    contentStream.restoreGraphicsState();
                    contentStream.close();
                    ++i;
                }
                doc.save(pdfOutputStream);
            }
            finally {
                if (doc != null) {
                    doc.close();
                }
            }
        }
    }

    public static void imageTextStamp(InputStream pdfInputStream, OutputStream pdfOutputStream, InputStream imageInputStream, float imageTopLeftX, float imageTopLeftY, float imageWidth, float imageHeight, float imageOpacity, String textMessage, float textTopLeftX, float textTopLeftY, String textFontType, String textFont, InputStream ttfInputStream, float textFontSize, int textRed, int textGreen, int textBlue, String textEncoding, int textRotation, float textOpacity, String password, String certKey) throws Exception {
        if (pdfInputStream != null) {
            PDFKey.toVal(certKey);
            SMDocument doc = null;
            try {
                doc = SMDocument.load(pdfInputStream);
                if (doc.isEncrypted()) {
                    doc.decrypt(password);
                }
                doc.CopyResourcesIntoPage();
                SMJpeg ximage = null;
                ximage = new SMJpeg(doc, imageInputStream);
                SMExtendedGraphicsState gsi = new SMExtendedGraphicsState();
                if (imageOpacity < 1.0f) {
                    gsi.setNonStrokingAlphaConstant(imageOpacity);
                }
                SMSimpleFont smFont = textFontType.equalsIgnoreCase("TYPE1") ? new SMType1Font(textFont) : SMTrueTypeFont.loadTTF(doc, ttfInputStream);
                SMExtendedGraphicsState gst = new SMExtendedGraphicsState();
                if (textOpacity < 1.0f) {
                    gst.setNonStrokingAlphaConstant(textOpacity);
                }
                int i = 0;
                while (i < doc.getNumberOfPages()) {
                    SMPage page = (SMPage)doc.getDocumentCatalog().getAllPages().get(i);
                    SMPageContentStream cs_before = new SMPageContentStream(doc, page, true, true, true);
                    cs_before.saveGraphicsState();
                    cs_before.close();
                    SMPageContentStream cs_after = new SMPageContentStream(doc, page, true, true);
                    cs_after.restoreGraphicsState();
                    cs_after.close();
                    SMRectangle pageSize = page.findMediaBox();
                    float pageheight = pageSize.getHeight();
                    float stringWidth = smFont.getStringWidth(textMessage);
                    float textX = textTopLeftX == -1.0f ? (pageSize.getWidth() - stringWidth * textFontSize / 1000.0f) / 2.0f : (textTopLeftX == -2.0f ? pageSize.getWidth() - stringWidth * textFontSize / 1000.0f : textTopLeftX);
                    float textY = textTopLeftY == -1.0f ? (pageheight - textFontSize) / 2.0f : (textTopLeftY == -2.0f ? 0.0f : pageheight - textTopLeftY - textFontSize);
                    if (imageHeight == -1.0f) {
                        imageHeight = ((SMXObjectImage)ximage).getHeight();
                    }
                    if (imageWidth == -1.0f) {
                        imageWidth = ((SMXObjectImage)ximage).getWidth();
                    }
                    float imageY = imageTopLeftY == -1.0f ? (pageSize.getHeight() - imageHeight) / 2.0f : (imageTopLeftY == -2.0f ? 0.0f : pageheight - imageTopLeftY - imageHeight);
                    float imageX = imageTopLeftX == -1.0f ? (pageSize.getWidth() - imageWidth) / 2.0f : (imageTopLeftX == -2.0f ? pageSize.getWidth() - imageWidth : imageTopLeftX);
                    SMPageContentStream contentStream = new SMPageContentStream(doc, page, true, true);
                    contentStream.saveGraphicsState();
                    if (imageOpacity < 1.0f) {
                        contentStream.startOpacity(gsi.getOMDictionary());
                    }
                    if (imageWidth == -1.0f && imageHeight == -1.0f) {
                        contentStream.drawImage(ximage, imageX, imageY);
                    } else {
                        contentStream.drawXObject(ximage, imageX, imageY, imageWidth, imageHeight);
                    }
                    if (imageOpacity < 1.0f) {
                        contentStream.endOpacity();
                    }
                    contentStream.restoreGraphicsState();
                    contentStream.saveGraphicsState();
                    if (textOpacity < 1.0f) {
                        contentStream.startOpacity(gst.getOMDictionary());
                    }
                    contentStream.setNonStrokingColor(textRed, textGreen, textBlue);
                    contentStream.beginText();
                    if (textFontType.equalsIgnoreCase("TYPE1")) {
                        if (textEncoding != null && !textEncoding.equalsIgnoreCase("cp1252")) {
                            smFont.setEncodingDiffs(textEncoding, textFont);
                        }
                        if (textEncoding != null && textEncoding.equalsIgnoreCase("cp1252")) {
                            smFont.setEncoding(new WinAnsiEncoding());
                        }
                    }
                    contentStream.setFont(smFont, textFontSize);
                    contentStream.moveTextPositionByAmount(textX, textY);
                    if (textRotation == 0) {
                        if (textEncoding != null) {
                            contentStream.drawString(textMessage, textEncoding);
                        } else {
                            contentStream.drawString(textMessage);
                        }
                    } else {
                        double alpha = (double)textRotation * Math.PI / 180.0;
                        float cos = (float)Math.cos(alpha);
                        float sin = (float)Math.sin(alpha);
                        float len = stringWidth * textFontSize / 1000.0f / 2.0f;
                        float xpos = textX + len - len * cos;
                        float ypos = textY - len * sin;
                        contentStream.setTextMatrix(cos, sin, -sin, cos, xpos, ypos);
                        if (textEncoding != null) {
                            contentStream.drawString(textMessage, textEncoding);
                        } else {
                            contentStream.drawString(textMessage);
                        }
                        contentStream.setTextMatrix(0.0f, 0.0f);
                    }
                    contentStream.endText();
                    if (textOpacity < 1.0f) {
                        contentStream.endOpacity();
                    }
                    contentStream.restoreGraphicsState();
                    contentStream.close();
                    ++i;
                }
                doc.save(pdfOutputStream);
            }
            finally {
                if (doc != null) {
                    doc.close();
                }
            }
        }
    }

    public static void imageStamp_1(SMDocument doc, InputStream imageInputStream, float topLeftX, float topLeftY, float width, float height, float opacity, String password, String certKey) throws Exception {
        if (doc.isEncrypted()) {
            doc.decrypt(password);
        }
        SMJpeg ximage = null;
        ximage = new SMJpeg(doc, imageInputStream);
        SMExtendedGraphicsState gs = new SMExtendedGraphicsState();
        if (opacity < 1.0f) {
            gs.setNonStrokingAlphaConstant(opacity);
        }
        int i = 0;
        while (i < doc.getNumberOfPages()) {
            SMPage page = (SMPage)doc.getDocumentCatalog().getAllPages().get(i);
            SMPageContentStream cs_before = new SMPageContentStream(doc, page, true, true, true);
            cs_before.saveGraphicsState();
            cs_before.close();
            SMPageContentStream cs_after = new SMPageContentStream(doc, page, true, true);
            cs_after.restoreGraphicsState();
            cs_after.close();
            SMPageContentStream contentStream = new SMPageContentStream(doc, page, true, true);
            contentStream.saveGraphicsState();
            SMRectangle pageSize = page.findMediaBox();
            float pageheight = pageSize.getHeight();
            if (height == -1.0f) {
                height = ((SMXObjectImage)ximage).getHeight();
            }
            if (width == -1.0f) {
                width = ((SMXObjectImage)ximage).getWidth();
            }
            float y = topLeftY == -1.0f ? (pageSize.getHeight() - height) / 2.0f : (topLeftY == -2.0f ? 0.0f : pageheight - topLeftY - height);
            float x = topLeftX == -1.0f ? (pageSize.getWidth() - width) / 2.0f : (topLeftX == -2.0f ? pageSize.getWidth() - width : topLeftX);
            if (opacity < 1.0f) {
                contentStream.startOpacity(gs.getOMDictionary());
            }
            if (width == -1.0f && height == -1.0f) {
                contentStream.drawImage(ximage, x, y);
            } else {
                contentStream.drawXObject(ximage, x, y, width, height);
            }
            if (opacity < 1.0f) {
                contentStream.endOpacity();
            }
            contentStream.restoreGraphicsState();
            contentStream.close();
            ++i;
        }
    }

    public static void imageStamp3(InputStream pdfInputStream1, InputStream pdfInputStream2, InputStream pdfInputStream3, OutputStream pdfOutputStream, InputStream imageInputStream1, InputStream imageInputStream2, InputStream imageInputStream3, float topLeftX, float topLeftY, float width, float height, float opacity, String password1, String password2, String password3, String certKey) throws Exception {
        if (pdfInputStream1 != null && pdfInputStream2 != null && pdfInputStream3 != null) {
            PDFKey.toVal(certKey);
            SMDocument doc1 = null;
            SMDocument doc2 = null;
            SMDocument doc3 = null;
            try {
                doc1 = SMDocument.load(pdfInputStream1);
                doc2 = SMDocument.load(pdfInputStream2);
                doc3 = SMDocument.load(pdfInputStream3);
                ImageStamp.imageStamp_1(doc1, imageInputStream1, topLeftX, topLeftY, width, height, opacity, password1, certKey);
                ImageStamp.imageStamp_1(doc2, imageInputStream2, topLeftX, topLeftY, width, height, opacity, password2, certKey);
                PDFMergerUtility merger1 = new PDFMergerUtility();
                merger1.appendDocument(doc1, doc2);
                ImageStamp.imageStamp_1(doc3, imageInputStream3, topLeftX, topLeftY, width, height, opacity, password3, certKey);
                PDFMergerUtility merger2 = new PDFMergerUtility();
                merger2.appendDocument(doc1, doc3);
                doc1.save(pdfOutputStream);
            }
            finally {
                if (doc1 != null) {
                    doc1.close();
                }
            }
        }
    }
}

