/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.edit.SMPageContentStream;
import com.plpdf.smmodel.graphics.optionalcontent.SMOptionalContentGroup;
import com.plpdf.smmodel.graphics.xobject.SMJpeg;
import com.plpdf.smmodel.graphics.xobject.SMXObjectImage;
import com.plpdf.util.PDFKey;
import java.io.InputStream;
import java.io.OutputStream;

class ImageLayer {
    ImageLayer() {
    }

    public void imagelayer(InputStream pdfInputStream, OutputStream pdfOutputStream, InputStream imageInputStream, int pagenum, String layername, float LowerLeftX, float LowerLeftY, float width, float height, String password, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument doc = null;
        try {
            doc = SMDocument.load(pdfInputStream);
            if (doc.isEncrypted()) {
                doc.decrypt(password);
            }
            if (doc.getDocument().getVersion() < 1.5f) {
                doc.setVersion(1.5f);
            }
            SMJpeg ximage = null;
            ximage = new SMJpeg(doc, imageInputStream);
            SMOptionalContentGroup lay = new SMOptionalContentGroup(doc, layername, true);
            SMPage page = (SMPage)doc.getDocumentCatalog().getAllPages().get(pagenum - 1);
            SMPageContentStream cs_before = new SMPageContentStream(doc, page, true, true, true);
            cs_before.saveGraphicsState();
            cs_before.close();
            SMPageContentStream cs_after = new SMPageContentStream(doc, page, true, true);
            cs_after.restoreGraphicsState();
            cs_after.close();
            SMPageContentStream contentStream = new SMPageContentStream(doc, page, true, true, false);
            SMRectangle pageSize = page.findMediaBox();
            if (height == -1.0f) {
                height = ((SMXObjectImage)ximage).getHeight();
            }
            if (width == -1.0f) {
                width = ((SMXObjectImage)ximage).getWidth();
            }
            if (LowerLeftY == -1.0f) {
                float centeredPositionY;
                LowerLeftY = centeredPositionY = (pageSize.getHeight() - height) / 2.0f;
            } else if (LowerLeftY == -2.0f) {
                float topedPositionY;
                LowerLeftY = topedPositionY = pageSize.getHeight() - height;
            }
            if (LowerLeftX == -1.0f) {
                float centeredPositionX;
                LowerLeftX = centeredPositionX = (pageSize.getWidth() - width) / 2.0f;
            } else if (LowerLeftX == -2.0f) {
                float rightedPositionX;
                LowerLeftX = rightedPositionX = pageSize.getWidth() - width;
            }
            contentStream.beginLayer(lay);
            if (width == -1.0f && height == -1.0f) {
                contentStream.drawImage(ximage, LowerLeftX, LowerLeftY);
            } else {
                contentStream.drawXObject(ximage, LowerLeftX, LowerLeftY, width, height);
            }
            contentStream.endLayer();
            contentStream.close();
            doc.save(pdfOutputStream);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }
}

