/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMDocumentCatalog;
import com.plpdf.smmodel.common.SMMetadata;
import com.plpdf.util.PDFKey;
import com.plpdf.xmp2.xmp.XMPMetadata;
import com.plpdf.xmp2.xmp.pdfa.XMPMetadataPDFA;
import com.plpdf.xmp2.xmp.pdfa.XMPSchemaPDFAId;
import java.io.IOException;
import java.io.InputStream;

public class GetPDFACompliant {
    private static final String CLASS_NAME = GetPDFACompliant.class.getName();

    private GetPDFACompliant() {
    }

    public static String getpdfacomp(InputStream pdfInputStream, String password, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument pdf = null;
        try {
            XMPMetadata xmp;
            pdf = SMDocument.load(pdfInputStream);
            if (pdf.isEncrypted()) {
                pdf.decrypt(password);
            }
            SMDocumentCatalog catalog = pdf.getDocumentCatalog();
            SMMetadata meta = catalog.getMetadata();
            String ret = "--";
            if (meta != null && (xmp = meta.exportXMPMetadata()) != null) {
                XMPMetadataPDFA xmpa = new XMPMetadataPDFA(xmp.getXMPDocument());
                XMPSchemaPDFAId id = xmpa.getPDFAIdSchema();
                String conf = "-";
                String part = "-";
                conf = id.getConformance();
                part = id.getPart().toString();
                if (conf == null) {
                    conf = "-";
                }
                if (part == null) {
                    part = "-";
                }
                ret = String.valueOf(part) + conf;
            }
            String string = ret;
            return string;
        }
        finally {
            if (pdf != null) {
                try {
                    pdf.close();
                }
                catch (IOException e) {
                    throw new PlpdfException("FailedToCloseDocument", e);
                }
            }
        }
    }
}

