/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMDocumentInformation;
import com.plpdf.smmodel.SMPage;
import com.plpdf.util.PDFKey;
import com.plpdf.util.PageCalc;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class ExtractPages {
    private static final String CLASS_NAME = ExtractPages.class.getName();

    private ExtractPages() {
    }

    public static void extractPages(InputStream pdfInputStream, OutputStream pdfOutputStream, int startPage, int endPage, String password, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument document = null;
        SMDocument document2 = null;
        try {
            document = SMDocument.load(pdfInputStream);
            if (document.isEncrypted()) {
                document.decrypt(password);
            }
            document.CopyResourcesIntoPage();
            int nop = document.getNumberOfPages();
            int[] r = PageCalc.calcNums(startPage, endPage, nop);
            startPage = r[0];
            endPage = r[1];
            SMDocumentInformation info = document.getDocumentInformation();
            document2 = new SMDocument();
            document2.setDocumentInformation(info);
            List pages = document.getDocumentCatalog().getAllPages();
            int i = startPage - 1;
            while (i < endPage && i < pages.size()) {
                SMPage page = (SMPage)pages.get(i);
                page.setCropBox(page.findCropBox());
                page.setMediaBox(page.findMediaBox());
                page.setRotation(page.findRotation());
                document2.importPage(page);
                ++i;
            }
            document2.save(pdfOutputStream);
        }
        finally {
            if (document != null) {
                document.close();
            }
            if (document2 != null) {
                document2.close();
            }
        }
    }
}

