/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.encryption.AccessPermission;
import com.plpdf.smmodel.encryption.StandardDecryptionMaterial;
import com.plpdf.util.PDFKey;
import com.plpdf.util.PDFText2HTML;
import com.plpdf.util.PDFTextStripper;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class ExtractFormXObjectText {
    private static final String CLASS_NAME = ExtractFormXObjectText.class.getName();
    public static final String DEFAULT_ENCODING = "ISO-8859-1";

    private ExtractFormXObjectText() {
    }

    public static void extractFormXObjectText(InputStream pdfInputStream, OutputStream textOutputStream, String encoding, int startPage, int endPage, String html, String sort, String password, String certKey) throws Exception {
        boolean iSort;
        PDFKey.toVal(certKey);
        boolean toHTML = html != null ? html.equalsIgnoreCase("true") : false;
        boolean bl = iSort = sort != null ? sort.equalsIgnoreCase("true") : false;
        if (encoding != null && encoding.equals("")) {
            encoding = DEFAULT_ENCODING;
        }
        Writer output = null;
        SMDocument document = null;
        try {
            document = SMDocument.load(pdfInputStream);
            if (document.isEncrypted()) {
                StandardDecryptionMaterial sdm = new StandardDecryptionMaterial(password);
                document.openProtection(sdm);
                AccessPermission ap = document.getCurrentAccessPermission();
                if (!ap.canExtractContent()) {
                    throw new PlpdfException(CLASS_NAME, "NoPermissionToExtract");
                }
            }
            output = encoding != null ? new OutputStreamWriter(textOutputStream, encoding) : new OutputStreamWriter(textOutputStream);
            PDFTextStripper stripper = null;
            stripper = toHTML ? new PDFText2HTML(encoding) : new PDFTextStripper();
            stripper.setSortByPosition(iSort);
            stripper.setStartPage(startPage);
            stripper.setEndPage(endPage);
            stripper.writeFormXObjectText(document, output);
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (document != null) {
                document.close();
            }
        }
    }
}

