/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.fdf.FDFDocument;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.util.PDFKey;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class ExportXFDF {
    private static final String CLASS_NAME = ExportXFDF.class.getName();

    public static void exportXFDF(InputStream pdfInputStream, OutputStream xfdfOutputStream, boolean exportnull, String password, String certKey) throws Exception {
        PDFKey.toVal(certKey);
        SMDocument pdf = null;
        FDFDocument fdf = null;
        try {
            SMAcroForm form;
            pdf = SMDocument.load(pdfInputStream);
            if (pdf.isEncrypted()) {
                pdf.decrypt(password);
            }
            if ((form = pdf.getDocumentCatalog().getAcroForm()) == null) {
                throw new PlpdfException(CLASS_NAME, "NoForm");
            }
            fdf = form.exportFDF(exportnull);
            fdf.saveXFDF(new OutputStreamWriter(xfdfOutputStream, "UTF-8"));
        }
        finally {
            if (fdf != null) {
                fdf.close();
            }
            if (pdf != null) {
                pdf.close();
            }
        }
    }
}

