/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.encryption.AccessPermission;
import com.plpdf.smmodel.encryption.StandardProtectionPolicy;
import com.plpdf.util.PDFKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Encrypt {
    private static final String CLASS_NAME = Encrypt.class.getName();

    public static void encrypt(InputStream pdfInputStream, OutputStream pdfOutputStream, String oPassword, String uPassword, int keyLength, String canAssemble, String canExtractContent, String canExtractForAccessibility, String canFillInForm, String canModify, String canModifyAnnotations, String canPrint, String canPrintDegraded, String algorithm, String certKey) throws Exception {
        block13: {
            PDFKey.toVal(certKey);
            if (algorithm == "") {
                algorithm = "RC4";
            }
            if (algorithm.equalsIgnoreCase("AES") && keyLength == 0) {
                keyLength = 128;
            }
            if (keyLength == 0) {
                keyLength = 40;
            }
            SMDocument document = null;
            AccessPermission ap = new AccessPermission();
            ap.setCanAssembleDocument(canAssemble.equalsIgnoreCase("true"));
            ap.setCanExtractContent(canExtractContent.equalsIgnoreCase("true"));
            ap.setCanExtractForAccessibility(canExtractForAccessibility.equalsIgnoreCase("true"));
            ap.setCanFillInForm(canFillInForm.equalsIgnoreCase("true"));
            ap.setCanModify(canModify.equalsIgnoreCase("true"));
            ap.setCanModifyAnnotations(canModifyAnnotations.equalsIgnoreCase("true"));
            ap.setCanPrint(canPrint.equalsIgnoreCase("true"));
            ap.setCanPrintDegraded(canPrintDegraded.equalsIgnoreCase("true"));
            try {
                document = SMDocument.load(pdfInputStream);
                if (algorithm.equalsIgnoreCase("AES") && document.getDocument().getVersion() < 1.6f) {
                    document.setVersion(1.6f);
                }
                if (!document.isEncrypted()) {
                    StandardProtectionPolicy spp = new StandardProtectionPolicy(oPassword, uPassword, ap);
                    spp.setEncryptionKeyLength(keyLength);
                    spp.setAlgorithm(algorithm);
                    document.protect(spp);
                    document.save(pdfOutputStream);
                    break block13;
                }
                throw new PlpdfException(CLASS_NAME, "DocumentAlreadyEncrypted");
            }
            finally {
                if (document != null) {
                    try {
                        document.close();
                    }
                    catch (IOException e) {
                        throw new PlpdfException("FailedToCloseDocument", e);
                    }
                }
            }
        }
    }
}

