/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.toolkit;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.encryption.AccessPermission;
import com.plpdf.smmodel.encryption.StandardDecryptionMaterial;
import com.plpdf.util.PDFKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Decrypt {
    private static final String CLASS_NAME = Decrypt.class.getName();

    private Decrypt() {
    }

    public static void decrypt(InputStream pdfInputStream, OutputStream pdfOutputStream, String password, String certKey) throws Exception {
        block10: {
            PDFKey.toVal(certKey);
            SMDocument document = null;
            try {
                document = SMDocument.load(pdfInputStream);
                if (document.isEncrypted()) {
                    StandardDecryptionMaterial decryptionMaterial = new StandardDecryptionMaterial(password);
                    document.openProtection(decryptionMaterial);
                    AccessPermission ap = document.getCurrentAccessPermission();
                    if (ap.isOwnerPermission()) {
                        document.save(pdfOutputStream);
                        break block10;
                    }
                    throw new PlpdfException(CLASS_NAME, "NotOwner");
                }
                throw new PlpdfException(CLASS_NAME, "DocumentNotEncrypted");
            }
            finally {
                if (document != null) {
                    try {
                        document.close();
                    }
                    catch (IOException e) {
                        throw new PlpdfException("FailedToCloseDocument", e);
                    }
                }
            }
        }
    }
}

