/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.viewerpreferences;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMObjectable;

public class SMViewerPreferences
implements OMObjectable {
    public static final String NON_FULL_SCREEN_PAGE_MODE_USE_NONE = "UseNone";
    public static final String NON_FULL_SCREEN_PAGE_MODE_USE_OUTLINES = "UseOutlines";
    public static final String NON_FULL_SCREEN_PAGE_MODE_USE_THUMBS = "UseThumbs";
    public static final String NON_FULL_SCREEN_PAGE_MODE_USE_OPTIONAL_CONTENT = "UseOC";
    public static final String READING_DIRECTION_L2R = "L2R";
    public static final String READING_DIRECTION_R2L = "R2L";
    public static final String BOUNDARY_MEDIA_BOX = "MediaBox";
    public static final String BOUNDARY_CROP_BOX = "CropBox";
    public static final String BOUNDARY_BLEED_BOX = "BleedBox";
    public static final String BOUNDARY_TRIM_BOX = "TrimBox";
    public static final String BOUNDARY_ART_BOX = "ArtBox";
    private OMDictionary prefs;

    public SMViewerPreferences(OMDictionary dic) {
        this.prefs = dic;
    }

    public OMDictionary getDictionary() {
        return this.prefs;
    }

    public OMBase getOMObject() {
        return this.prefs;
    }

    public boolean hideToolbar() {
        return this.prefs.getBoolean(OMName.HIDE_TOOLBAR, false);
    }

    public void setHideToolbar(boolean value) {
        this.prefs.setBoolean(OMName.HIDE_TOOLBAR, value);
    }

    public boolean hideMenubar() {
        return this.prefs.getBoolean(OMName.HIDE_MENUBAR, false);
    }

    public void setHideMenubar(boolean value) {
        this.prefs.setBoolean(OMName.HIDE_MENUBAR, value);
    }

    public boolean hideWindowUI() {
        return this.prefs.getBoolean(OMName.HIDE_WINDOWUI, false);
    }

    public void setHideWindowUI(boolean value) {
        this.prefs.setBoolean(OMName.HIDE_WINDOWUI, value);
    }

    public boolean fitWindow() {
        return this.prefs.getBoolean(OMName.FIT_WINDOW, false);
    }

    public void setFitWindow(boolean value) {
        this.prefs.setBoolean(OMName.FIT_WINDOW, value);
    }

    public boolean centerWindow() {
        return this.prefs.getBoolean(OMName.CENTER_WINDOW, false);
    }

    public void setCenterWindow(boolean value) {
        this.prefs.setBoolean(OMName.CENTER_WINDOW, value);
    }

    public boolean displayDocTitle() {
        return this.prefs.getBoolean(OMName.DISPLAY_DOC_TITLE, false);
    }

    public void setDisplayDocTitle(boolean value) {
        this.prefs.setBoolean(OMName.DISPLAY_DOC_TITLE, value);
    }

    public String getNonFullScreenPageMode() {
        return this.prefs.getNameAsString(OMName.NON_FULL_SCREEN_PAGE_MODE, NON_FULL_SCREEN_PAGE_MODE.UseNone.toString());
    }

    public void setNonFullScreenPageMode(NON_FULL_SCREEN_PAGE_MODE value) {
        this.prefs.setName(OMName.NON_FULL_SCREEN_PAGE_MODE, value.toString());
    }

    public void setNonFullScreenPageMode(String value) {
        this.prefs.setName(OMName.NON_FULL_SCREEN_PAGE_MODE, value);
    }

    public String getReadingDirection() {
        return this.prefs.getNameAsString(OMName.DIRECTION, READING_DIRECTION.L2R.toString());
    }

    public void setReadingDirection(READING_DIRECTION value) {
        this.prefs.setName(OMName.DIRECTION, value.toString());
    }

    public void setReadingDirection(String value) {
        this.prefs.setName(OMName.DIRECTION, value.toString());
    }

    public String getViewArea() {
        return this.prefs.getNameAsString(OMName.VIEW_AREA, BOUNDARY.CropBox.toString());
    }

    public void setViewArea(String value) {
        this.prefs.setName(OMName.VIEW_AREA, value);
    }

    public void setViewArea(BOUNDARY value) {
        this.prefs.setName(OMName.VIEW_AREA, value.toString());
    }

    public String getViewClip() {
        return this.prefs.getNameAsString(OMName.VIEW_CLIP, BOUNDARY.CropBox.toString());
    }

    public void setViewClip(BOUNDARY value) {
        this.prefs.setName(OMName.VIEW_CLIP, value.toString());
    }

    public void setViewClip(String value) {
        this.prefs.setName(OMName.VIEW_CLIP, value);
    }

    public String getPrintArea() {
        return this.prefs.getNameAsString(OMName.PRINT_AREA, BOUNDARY.CropBox.toString());
    }

    public void setPrintArea(String value) {
        this.prefs.setName(OMName.PRINT_AREA, value);
    }

    public void setPrintArea(BOUNDARY value) {
        this.prefs.setName(OMName.PRINT_AREA, value.toString());
    }

    public String getPrintClip() {
        return this.prefs.getNameAsString(OMName.PRINT_CLIP, BOUNDARY.CropBox.toString());
    }

    public void setPrintClip(String value) {
        this.prefs.setName(OMName.PRINT_CLIP, value);
    }

    public void setPrintClip(BOUNDARY value) {
        this.prefs.setName(OMName.PRINT_CLIP, value.toString());
    }

    public String getDuplex() {
        return this.prefs.getNameAsString(OMName.DUPLEX);
    }

    public void setDuplex(DUPLEX value) {
        this.prefs.setName(OMName.DUPLEX, value.toString());
    }

    public String getPrintScaling() {
        return this.prefs.getNameAsString(OMName.PRINT_SCALING, PRINT_SCALING.AppDefault.toString());
    }

    public void setPrintScaling(PRINT_SCALING value) {
        this.prefs.setName(OMName.PRINT_SCALING, value.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BOUNDARY {
        MediaBox,
        CropBox,
        BleedBox,
        TrimBox,
        ArtBox;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DUPLEX {
        Simplex,
        DuplexFlipShortEdge,
        DuplexFlipLongEdge;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NON_FULL_SCREEN_PAGE_MODE {
        UseNone,
        UseOutlines,
        UseThumbs,
        UseOC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PRINT_SCALING {
        None,
        AppDefault;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum READING_DIRECTION {
        L2R,
        R2L;

    }
}

