/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.measurement;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMObjectable;
import java.io.IOException;

public class SMNumberFormatDictionary
implements OMObjectable {
    public static final String TYPE = "NumberFormat";
    public static final String LABEL_SUFFIX_TO_VALUE = "S";
    public static final String LABEL_PREFIX_TO_VALUE = "P";
    public static final String FRACTIONAL_DISPLAY_DECIMAL = "D";
    public static final String FRACTIONAL_DISPLAY_FRACTION = "F";
    public static final String FRACTIONAL_DISPLAY_ROUND = "R";
    public static final String FRACTIONAL_DISPLAY_TRUNCATE = "T";
    private OMDictionary numberFormatDictionary;

    public SMNumberFormatDictionary() {
        this.numberFormatDictionary = new OMDictionary();
        this.numberFormatDictionary.setName(OMName.TYPE, TYPE);
    }

    public SMNumberFormatDictionary(OMDictionary dictionary) {
        this.numberFormatDictionary = dictionary;
    }

    public OMBase getOMObject() {
        return this.numberFormatDictionary;
    }

    public OMDictionary getDictionary() {
        return this.numberFormatDictionary;
    }

    public String getType() {
        return TYPE;
    }

    public String getUnits() {
        return this.getDictionary().getString("U");
    }

    public void setUnits(String units) throws IOException {
        this.getDictionary().setString("U", units);
    }

    public float getConversionFactor() {
        return this.getDictionary().getFloat("C");
    }

    public void setConversionFactor(float conversionFactor) {
        this.getDictionary().setFloat("C", conversionFactor);
    }

    public String getFractionalDisplay() {
        return this.getDictionary().getString(FRACTIONAL_DISPLAY_FRACTION, FRACTIONAL_DISPLAY_DECIMAL);
    }

    public void setFractionalDisplay(String fractionalDisplay) throws IOException {
        if (!(fractionalDisplay == null || FRACTIONAL_DISPLAY_DECIMAL.equals(fractionalDisplay) || FRACTIONAL_DISPLAY_FRACTION.equals(fractionalDisplay) || FRACTIONAL_DISPLAY_ROUND.equals(fractionalDisplay) || FRACTIONAL_DISPLAY_TRUNCATE.equals(fractionalDisplay))) {
            throw new IllegalArgumentException("Value must be \"D\", \"F\", \"R\", or \"T\", (or null).");
        }
        this.getDictionary().setString(FRACTIONAL_DISPLAY_FRACTION, fractionalDisplay);
    }

    public int getDenominator() {
        return this.getDictionary().getInt(FRACTIONAL_DISPLAY_DECIMAL);
    }

    public void setDenominator(int denominator) {
        this.getDictionary().setInt(FRACTIONAL_DISPLAY_DECIMAL, denominator);
    }

    public boolean isFD() {
        return this.getDictionary().getBoolean("FD", false);
    }

    public void setFD(boolean fd) {
        this.getDictionary().setBoolean("FD", fd);
    }

    public String getThousandsSeparator() {
        return this.getDictionary().getString("RT", ",");
    }

    public void setThousandsSeparator(String thousandsSeparator) throws IOException {
        this.getDictionary().setString("RT", thousandsSeparator);
    }

    public String getDecimalSeparator() {
        return this.getDictionary().getString("RD", ".");
    }

    public void setDecimalSeparator(String decimalSeparator) throws IOException {
        this.getDictionary().setString("RD", decimalSeparator);
    }

    public String getLabelPrefixString() {
        return this.getDictionary().getString("PS", " ");
    }

    public void setLabelPrefixString(String labelPrefixString) throws IOException {
        this.getDictionary().setString("PS", labelPrefixString);
    }

    public String getLabelSuffixString() {
        return this.getDictionary().getString("SS", " ");
    }

    public void setLabelSuffixString(String labelSuffixString) throws IOException {
        this.getDictionary().setString("SS", labelSuffixString);
    }

    public String getLabelPositionToValue() {
        return this.getDictionary().getString("O", LABEL_SUFFIX_TO_VALUE);
    }

    public void setLabelPositionToValue(String labelPositionToValue) throws IOException {
        if (labelPositionToValue != null && !LABEL_PREFIX_TO_VALUE.equals(labelPositionToValue) && !LABEL_SUFFIX_TO_VALUE.equals(labelPositionToValue)) {
            throw new IllegalArgumentException("Value must be \"S\", or \"P\" (or null).");
        }
        this.getDictionary().setString("O", labelPositionToValue);
    }
}

