/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.form;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMStream;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SMXFA
implements OMObjectable {
    private OMBase xfa;
    public static final String XFA_DATA_SCHEMA = "http://www.xfa.org/schema/xfa-data/1.0/";
    private OMBase datasetsobj;
    private Document datasetsdoc;
    private Element datasets;
    private boolean changed;
    private int datasetsindex;

    public SMXFA(OMBase xfaBase) throws PlpdfException, IOException {
        this.xfa = xfaBase;
        if (this.xfa instanceof OMArray) {
            String name = null;
            OMArray xfaArray = (OMArray)this.xfa;
            int i = 0;
            while (i < xfaArray.size()) {
                OMBase item = xfaArray.get(i);
                if (item instanceof OMString) {
                    name = ((OMString)item).toStringBytes();
                } else if (!(item instanceof OMStream) && item instanceof OMObject) {
                    SMStream retval1 = null;
                    OMBase obj = ((OMObject)item).getObject();
                    retval1 = SMStream.createFromOM(obj);
                    if (name.equalsIgnoreCase("datasets")) {
                        this.datasetsindex = i;
                        this.datasetsobj = obj;
                        this.datasetsdoc = XMLUtil.parse(retval1.createInputStream());
                        this.datasets = this.datasetsdoc.getDocumentElement();
                        if (!this.datasets.getNodeName().equals("xfa:datasets")) {
                            throw new PlpdfException(this.getClass().getName(), "InvalidDocumnetRoot", new String[]{this.datasets.getNodeName()});
                        }
                    }
                }
                ++i;
            }
        } else {
            boolean cfr_ignored_0 = this.xfa instanceof OMStream;
        }
        if (this.datasets == null) {
            this.createDatasets();
        }
    }

    public void createDatasets() {
        this.datasets = this.datasetsdoc.createElement("xfa:datasets");
        this.datasets.setAttribute("xmlns:xfa", XFA_DATA_SCHEMA);
    }

    public OMBase getOMObject() {
        return this.xfa;
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream is = null;
        byte[] xfaBytes = null;
        try {
            if (this.getOMObject() instanceof OMArray) {
                xfaBytes = new byte[1024];
                OMArray cosArray = (OMArray)this.getOMObject();
                int i = 1;
                while (i < cosArray.size()) {
                    OMBase cosObj = cosArray.getObject(i);
                    if (cosObj instanceof OMStream) {
                        is = ((OMStream)cosObj).getUnfilteredStream();
                        int nRead = 0;
                        while ((nRead = is.read(xfaBytes, 0, xfaBytes.length)) != -1) {
                            baos.write(xfaBytes, 0, nRead);
                        }
                        baos.flush();
                    }
                    i += 2;
                }
            } else if (this.xfa.getOMObject() instanceof OMStream) {
                xfaBytes = new byte[1024];
                is = ((OMStream)this.xfa.getOMObject()).getUnfilteredStream();
                int nRead = 0;
                while ((nRead = is.read(xfaBytes, 0, xfaBytes.length)) != -1) {
                    baos.write(xfaBytes, 0, nRead);
                }
                baos.flush();
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return baos.toByteArray();
    }

    public Document getDocument() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document xfaDocument = builder.parse(new ByteArrayInputStream(this.getBytes()));
        return xfaDocument;
    }

    public void fillXfaForm(Element e) {
        NodeList list;
        NodeList allChilds = this.datasets.getChildNodes();
        int len = allChilds.getLength();
        Node data = null;
        int k = 0;
        while (k < len) {
            Node n = allChilds.item(k);
            if (n.getNodeType() == 1 && n.getNodeName().equals("xfa:data")) {
                data = n;
                break;
            }
            ++k;
        }
        if (data == null) {
            data = this.datasets.getOwnerDocument().createElementNS(XFA_DATA_SCHEMA, "xfa:data");
            this.datasets.appendChild(data);
        }
        if ((list = data.getChildNodes()).getLength() == 0) {
            data.appendChild(this.datasetsdoc.importNode(e, true));
        } else {
            data.replaceChild(this.datasetsdoc.importNode(e, true), data.getFirstChild());
        }
        this.changed = true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void writeXFAForm() throws Exception {
        if (this.isChanged()) {
            if (this.xfa instanceof OMArray) {
                if (this.datasetsobj != null) {
                    OutputStream output = ((OMStream)this.datasetsobj).createUnfilteredStream();
                    XMLUtil.ElementToStream(this.datasets, output);
                    ((OMArray)this.xfa).set(this.datasetsindex, this.datasetsobj);
                }
            } else {
                boolean cfr_ignored_0 = this.xfa instanceof OMStream;
            }
        }
    }
}

