/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.form;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.smmodel.interactive.form.SMAppearance;
import com.plpdf.smmodel.interactive.form.SMField;
import com.plpdf.util.BitFlagHelper;
import java.io.IOException;

public abstract class SMVariableText
extends SMField {
    public static final int FLAG_MULTILINE = 4096;
    public static final int FLAG_PASSWORD = 8192;
    public static final int FLAG_FILE_SELECT = 0x100000;
    public static final int FLAG_DO_NOT_SPELL_CHECK = 0x400000;
    public static final int FLAG_DO_NOT_SCROLL = 0x800000;
    public static final int FLAG_COMB = 0x1000000;
    public static final int FLAG_RICH_TEXT = 0x2000000;
    private OMString da;
    private SMAppearance appearance;
    public static final int QUADDING_LEFT = 0;
    public static final int QUADDING_CENTERED = 1;
    public static final int QUADDING_RIGHT = 2;

    public SMVariableText(SMAcroForm theAcroForm) {
        super(theAcroForm);
    }

    public SMVariableText(SMAcroForm theAcroForm, OMDictionary field) {
        super(theAcroForm, field);
        this.da = (OMString)field.getDictionaryObject(OMName.DA);
    }

    public void setValue(String value) throws IOException, CryptographyException, PlpdfException {
        OMString fieldValue = new OMString(value);
        this.getDictionary().setItem(OMName.V, (OMBase)fieldValue);
        if (this.appearance == null) {
            this.appearance = new SMAppearance(this.getAcroForm(), this);
        }
        this.appearance.setAppearanceValue(value);
    }

    public String getValue() throws IOException {
        return this.getDictionary().getString(OMName.V);
    }

    public boolean isMultiline() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 4096);
    }

    public void setMultiline(boolean multiline) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 4096, multiline);
    }

    public boolean isPassword() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 8192);
    }

    public void setPassword(boolean password) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 8192, password);
    }

    public boolean isFileSelect() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 0x100000);
    }

    public void setFileSelect(boolean fileSelect) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 0x100000, fileSelect);
    }

    public boolean doNotSpellCheck() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 0x400000);
    }

    public void setDoNotSpellCheck(boolean doNotSpellCheck) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 0x400000, doNotSpellCheck);
    }

    public boolean doNotScroll() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 0x800000);
    }

    public void setDoNotScroll(boolean doNotScroll) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 0x800000, doNotScroll);
    }

    public boolean shouldComb() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 0x1000000);
    }

    public void setComb(boolean comb) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 0x1000000, comb);
    }

    public boolean isRichText() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 0x2000000);
    }

    public void setRichText(boolean richText) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 0x2000000, richText);
    }

    protected OMString getDefaultAppearance() {
        return this.da;
    }

    public int getQ() {
        int retval = 0;
        OMNumber number = (OMNumber)this.getDictionary().getDictionaryObject(OMName.Q);
        if (number != null) {
            retval = number.intValue();
        }
        return retval;
    }

    public void setQ(int q) {
        this.getDictionary().setInt(OMName.Q, q);
    }

    public String getDefaultValue() throws IOException {
        return this.getDictionary().getString(OMName.DV);
    }
}

