/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.form;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.font.SMType1Font;
import com.plpdf.smmodel.graphics.SMLineDashPattern;
import com.plpdf.smmodel.graphics.color.SMGamma;
import com.plpdf.smmodel.graphics.optionalcontent.SMOptionalContentGroup;
import com.plpdf.smmodel.graphics.xobject.SMTemplateXObject;
import com.plpdf.smmodel.interactive.action.type.SMActionHide;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationWidget;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceDictionary;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceStream;
import com.plpdf.smmodel.interactive.annotation.SMBorderStyleDictionary;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.smmodel.interactive.form.SMVariableText;
import com.plpdf.util.MapUtil;
import java.awt.Color;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;

public class SMTextField
extends SMVariableText {
    private SMAnnotationWidget annot;
    private SMActionHide show;
    private SMActionHide hide;
    private String partialname;
    private NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);

    public SMTextField(SMDocument doc, SMAcroForm theAcroForm, float x, float y, float width, float height) throws IOException, PlpdfException {
        super(theAcroForm);
        this.annot = new SMAnnotationWidget();
        this.annot.setAnnotationFlags(0);
        this.setDictionary(this.annot.getDictionary());
        this.setNoExport(true);
        this.setFieldType("Tx");
        this.setRectangle(x, y, width, height);
        SMTemplateXObject ss = new SMTemplateXObject(doc);
        ss.beginVariableText();
        ss.endVariableText();
        ss.writeToStream();
        OMStream om = ss.getStream();
        SMRectangle r = new SMRectangle(width, height);
        r.move(x, y);
        om.setItem(OMName.getPDFName("BBox"), (OMBase)r.getOMArray());
        SMAppearanceStream as = new SMAppearanceStream(om);
        SMAppearanceDictionary ap = new SMAppearanceDictionary();
        this.getDictionary().setItem("AP", (OMObjectable)ap);
        ap.setNormalAppearance(as);
    }

    public SMTextField(SMAcroForm theAcroForm, OMDictionary field) {
        super(theAcroForm, field);
    }

    public void setAppChar(Color bg, Color bc) {
        OMDictionary mk = new OMDictionary();
        SMGamma bg_gamma = new SMGamma();
        SMGamma bc_gamma = new SMGamma();
        if (bg != null) {
            bg_gamma.setColor(bg);
            mk.setItem("BG", (OMObjectable)bg_gamma);
        }
        if (bc != null) {
            bc_gamma.setColor(bc);
            mk.setItem("BC", (OMObjectable)bc_gamma);
        }
        if (bg != null || bc != null) {
            this.getDictionary().setItem("MK", (OMBase)mk);
        }
    }

    public void setBorderStyle(int width, String style, OMArray dash) {
        SMBorderStyleDictionary bs = new SMBorderStyleDictionary();
        if (width > 0) {
            bs.setWidth(width);
        }
        if (style != null) {
            bs.setStyle(style);
        }
        if (dash != null) {
            SMLineDashPattern p = new SMLineDashPattern(dash);
            bs.setDashStyle(p);
        }
        this.getDictionary().setItem("BS", (OMObjectable)bs);
    }

    public void setBorderStyle(int width, String style) {
        this.setBorderStyle(width, style, null);
    }

    public void setDefApp(String da) throws IOException, PlpdfException {
        if (da != null) {
            this.getDictionary().setString("DA", da);
        }
    }

    public void setDefApp(SMAcroForm af, String font, float fontSize) throws IOException, PlpdfException {
        SMType1Font smFont = new SMType1Font(font);
        Map fonts = af.getFonts();
        String fontMapping = MapUtil.getNextUniqueKey(fonts, "F");
        fonts.put(fontMapping, smFont);
        af.setFonts(fonts);
        String s = fontSize > 0.0f ? "/" + fontMapping + " " + this.formatDecimal.format(fontSize) + " Tf 0 g" : "/" + fontMapping + " " + "0" + " Tf 0 g";
        this.setDefApp(s);
    }

    public void setValue(String value) throws IOException {
        OMString fieldValue = new OMString(value);
        this.getDictionary().setItem(OMName.getPDFName("V"), (OMBase)fieldValue);
    }

    public String getValue() throws IOException {
        return this.getDictionary().getString("V");
    }

    public void setDefaultValue(String value) throws IOException, PlpdfException {
        OMString fieldValue = new OMString(value);
        this.getDictionary().setItem(OMName.getPDFName("DV"), (OMBase)fieldValue);
    }

    public String getDefaultValue() throws IOException {
        return this.getDictionary().getString("DV");
    }

    public void setPage1(SMPage page) throws IOException, PlpdfException {
        this.setPage(page);
        page.addAnnotations(this);
    }

    public void setPage1(SMDocument doc, int pagenum) throws IOException, PlpdfException {
        SMPage page1 = (SMPage)doc.getDocumentCatalog().getAllPages().get(pagenum);
        this.setPage(page1);
        page1.addAnnotations(this);
    }

    public void setLayer(SMOptionalContentGroup layer) {
        this.getDictionary().setItem("OC", (OMObjectable)layer);
    }

    public void setHidden() {
        this.annot.setHidden(true);
    }
}

