/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.form;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.interactive.digitalsignature.SMSeedValue;
import com.plpdf.smmodel.interactive.digitalsignature.SMSignature;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.smmodel.interactive.form.SMField;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;

public class SMSignatureField
extends SMField {
    private static final String CLASS_NAME = SMSignature.class.getName();

    public SMSignatureField(SMAcroForm theAcroForm, OMDictionary field) throws IOException {
        super(theAcroForm, field);
        this.getDictionary().setItem(OMName.TYPE, (OMBase)OMName.ANNOT);
        this.getDictionary().setName(OMName.SUBTYPE, "Widget");
    }

    public SMSignatureField(SMAcroForm theAcroForm) throws IOException {
        super(theAcroForm);
        this.getDictionary().setItem(OMName.FT, (OMBase)OMName.SIG);
        this.getWidget().setLocked(true);
        this.getWidget().setPrinted(true);
        this.setPartialName(this.generatePartialName());
        this.getDictionary().setItem(OMName.TYPE, (OMBase)OMName.ANNOT);
        this.getDictionary().setName(OMName.SUBTYPE, "Widget");
    }

    private String generatePartialName() throws IOException {
        SMAcroForm acroForm = this.getAcroForm();
        List<SMField> fields = acroForm.getFields();
        String fieldName = "Signature";
        int i = 1;
        HashSet<String> sigNames = new HashSet<String>();
        for (SMField object : fields) {
            if (!(object instanceof SMSignatureField)) continue;
            sigNames.add(((SMSignatureField)object).getPartialName());
        }
        while (sigNames.contains(String.valueOf(fieldName) + i)) {
            ++i;
        }
        return String.valueOf(fieldName) + i;
    }

    @Deprecated
    public void setValue(String value) throws IOException, PlpdfException {
    }

    @Deprecated
    public String getValue() throws IOException, PlpdfException {
        return null;
    }

    public String toString() {
        return "SMSignature";
    }

    public void setSignature(SMSignature value) {
        this.getDictionary().setItem(OMName.V, (OMObjectable)value);
    }

    public SMSignature getSignature() {
        OMBase dictionary = this.getDictionary().getDictionaryObject(OMName.V);
        if (dictionary == null) {
            return null;
        }
        return new SMSignature((OMDictionary)dictionary);
    }

    public SMSeedValue getSeedValue() {
        OMDictionary dict = (OMDictionary)this.getDictionary().getDictionaryObject(OMName.SV);
        SMSeedValue sv = null;
        if (dict != null) {
            sv = new SMSeedValue(dict);
        }
        return sv;
    }

    public void setSeedValue(SMSeedValue sv) {
        if (sv != null) {
            this.getDictionary().setItem(OMName.SV, sv.getOMObject());
        }
    }

    public String getDefaultValue() throws IOException {
        return null;
    }
}

