/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.form;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.smmodel.interactive.form.SMCheckbox;
import com.plpdf.smmodel.interactive.form.SMChoiceButton;
import com.plpdf.smmodel.interactive.form.SMField;
import com.plpdf.smmodel.interactive.form.SMFieldFactory;
import com.plpdf.util.BitFlagHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SMRadioCollection
extends SMChoiceButton {
    public static final int FLAG_RADIOS_IN_UNISON = 0x2000000;

    public SMRadioCollection(SMAcroForm theAcroForm, OMDictionary field) {
        super(theAcroForm, field);
    }

    public void setRadiosInUnison(boolean radiosInUnison) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 0x2000000, radiosInUnison);
    }

    public boolean isRadiosInUnison() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 0x2000000);
    }

    public void setValue(String value) throws IOException {
        this.getDictionary().setName(OMName.V, value);
        List kids = this.getKids();
        int i = 0;
        while (i < kids.size()) {
            SMField field = (SMField)kids.get(i);
            if (field instanceof SMCheckbox) {
                SMCheckbox btn = (SMCheckbox)field;
                if (btn.getOnValue().equals(value)) {
                    btn.check();
                } else {
                    btn.unCheck();
                }
            }
            ++i;
        }
    }

    public String getValue() throws IOException {
        String retval = null;
        List kids = this.getKids();
        if (kids != null) {
            int i = 0;
            while (i < kids.size()) {
                SMCheckbox btn;
                SMField kid = (SMField)kids.get(i);
                if (kid instanceof SMCheckbox && (btn = (SMCheckbox)kid).isChecked()) {
                    retval = btn.getOnValue();
                }
                ++i;
            }
        }
        if (retval == null) {
            retval = this.getDictionary().getNameAsString(OMName.V);
        }
        return retval;
    }

    public List getKids() throws IOException {
        OMArrayList retval = null;
        OMArray kids = (OMArray)this.getDictionary().getDictionaryObject(OMName.KIDS);
        if (kids != null) {
            ArrayList<SMField> kidsList = new ArrayList<SMField>();
            int i = 0;
            while (i < kids.size()) {
                kidsList.add(SMFieldFactory.createField(this.getAcroForm(), (OMDictionary)kids.getObject(i)));
                ++i;
            }
            retval = new OMArrayList(kidsList, kids);
        }
        return retval;
    }

    public String getDefaultValue() throws IOException {
        return this.getDictionary().getNameAsString(OMName.DV);
    }
}

