/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.form;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationWidget;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.smmodel.interactive.form.SMCheckbox;
import com.plpdf.smmodel.interactive.form.SMChoiceField;
import com.plpdf.smmodel.interactive.form.SMField;
import com.plpdf.smmodel.interactive.form.SMPushButton;
import com.plpdf.smmodel.interactive.form.SMRadioCollection;
import com.plpdf.smmodel.interactive.form.SMSignatureField;
import com.plpdf.smmodel.interactive.form.SMTextbox;
import com.plpdf.smmodel.interactive.form.SMUnknownField;
import java.io.IOException;
import java.util.List;

public class SMFieldFactory {
    private static final int RADIO_BITMASK = 32768;
    private static final int PUSHBUTTON_BITMASK = 65536;
    private static final int RADIOS_IN_UNISON_BITMASK = 0x2000000;
    private static final String FIELD_TYPE_BTN = "Btn";
    private static final String FIELD_TYPE_TX = "Tx";
    private static final String FIELD_TYPE_CH = "Ch";
    private static final String FIELD_TYPE_SIG = "Sig";

    private SMFieldFactory() {
    }

    public static SMField createField(SMAcroForm acroForm, OMDictionary field) throws IOException {
        SMField pdField = new SMUnknownField(acroForm, field);
        if (SMFieldFactory.isButton(pdField)) {
            int flags = pdField.getFieldFlags();
            OMArray kids = (OMArray)field.getDictionaryObject(OMName.getPDFName("Kids"));
            pdField = kids != null || SMFieldFactory.isRadio(flags) ? new SMRadioCollection(acroForm, field) : (SMFieldFactory.isPushButton(flags) ? new SMPushButton(acroForm, field) : new SMCheckbox(acroForm, field));
        } else if (SMFieldFactory.isChoiceField(pdField)) {
            pdField = new SMChoiceField(acroForm, field);
        } else if (SMFieldFactory.isTextbox(pdField)) {
            pdField = new SMTextbox(acroForm, field);
        } else if (SMFieldFactory.isSignature(pdField)) {
            pdField = new SMSignatureField(acroForm, field);
        }
        return pdField;
    }

    private static boolean isRadio(int flags) {
        return (flags & 0x8000) > 0;
    }

    private static boolean isPushButton(int flags) {
        return (flags & 0x10000) > 0;
    }

    private static boolean isChoiceField(SMField field) throws IOException {
        return FIELD_TYPE_CH.equals(field.findFieldType());
    }

    private static boolean isButton(SMField field) throws IOException {
        String ft = field.findFieldType();
        boolean retval = FIELD_TYPE_BTN.equals(ft);
        List<OMObjectable> kids = field.getKids();
        if (ft == null && kids != null && kids.size() > 0) {
            OMObjectable obj = kids.get(0);
            OMDictionary kidDict = null;
            if (obj instanceof SMField) {
                kidDict = ((SMField)obj).getDictionary();
            } else if (obj instanceof SMAnnotationWidget) {
                kidDict = ((SMAnnotationWidget)obj).getDictionary();
            } else {
                throw new IOException("Error:Unexpected type of kids field:" + obj);
            }
            retval = SMFieldFactory.isButton(new SMUnknownField(field.getAcroForm(), kidDict));
        }
        return retval;
    }

    private static boolean isSignature(SMField field) throws IOException {
        return FIELD_TYPE_SIG.equals(field.findFieldType());
    }

    private static boolean isTextbox(SMField field) throws IOException {
        return FIELD_TYPE_TX.equals(field.findFieldType());
    }
}

