/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.form;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.common.SMTextStream;
import com.plpdf.smmodel.fdf.FDFField;
import com.plpdf.smmodel.graphics.optionalcontent.SMOptionalContentGroup;
import com.plpdf.smmodel.interactive.action.SMFormFieldAdditionalActions;
import com.plpdf.smmodel.interactive.action.type.SMAction;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationWidget;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.smmodel.interactive.form.SMFieldFactory;
import com.plpdf.util.BitFlagHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SMField
implements OMObjectable {
    public static final int FLAG_READ_ONLY = 1;
    public static final int FLAG_REQUIRED = 2;
    public static final int FLAG_NO_EXPORT = 4;
    public static final int FLAG_PUSHBUTTON = 65536;
    private SMAcroForm acroForm;
    private OMDictionary dictionary;

    public SMField(SMAcroForm theAcroForm) {
        this.acroForm = theAcroForm;
        this.dictionary = new OMDictionary();
    }

    public SMField(SMAcroForm theAcroForm, OMDictionary field) {
        this.acroForm = theAcroForm;
        this.dictionary = field;
    }

    public String getPartialName() {
        return this.getDictionary().getString(OMName.T);
    }

    public void setPartialName(String name) throws IOException {
        this.getDictionary().setString(OMName.T, name);
    }

    public String getFullyQualifiedName() throws IOException {
        SMField parent = this.getParent();
        String parentName = null;
        if (parent != null) {
            parentName = parent.getFullyQualifiedName();
        }
        String finalName = this.getPartialName();
        if (parentName != null) {
            finalName = String.valueOf(parentName) + "." + finalName;
        }
        return finalName;
    }

    public String getAlternateFieldName() {
        return this.getDictionary().getString(OMName.TU);
    }

    public void setAlternateFieldName(String alternateFieldName) throws IOException {
        this.getDictionary().setString(OMName.TU, alternateFieldName);
    }

    public String getFieldType() {
        return this.getDictionary().getNameAsString(OMName.FT);
    }

    public String findFieldType() {
        return this.findFieldType(this.getDictionary());
    }

    private String findFieldType(OMDictionary dic) {
        OMDictionary parent;
        String retval = dic.getNameAsString(OMName.FT);
        if (retval == null && (parent = (OMDictionary)dic.getDictionaryObject(OMName.PARENT, OMName.P)) != null) {
            retval = this.findFieldType(parent);
        }
        return retval;
    }

    public abstract void setValue(String var1) throws IOException, CryptographyException, PlpdfException;

    public abstract String getValue() throws IOException, PlpdfException;

    public void setReadonly(boolean readonly) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 1, readonly);
    }

    public boolean isReadonly() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 1);
    }

    public void setRequired(boolean required) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 2, required);
    }

    public boolean isRequired() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 2);
    }

    public void setNoExport(boolean noExport) {
        BitFlagHelper.setFlag(this.getDictionary(), OMName.FF, 4, noExport);
    }

    public boolean isNoExport() {
        return BitFlagHelper.getFlag(this.getDictionary(), OMName.FF, 4);
    }

    public int getFieldFlags() {
        int retval = 0;
        OMInteger ff = (OMInteger)this.getDictionary().getDictionaryObject(OMName.FF);
        if (ff != null) {
            retval = ff.intValue();
        }
        return retval;
    }

    public void setFieldFlags(int flags) {
        this.getDictionary().setInt(OMName.FF, flags);
    }

    public void importFDF(FDFField fdfField) throws IOException, CryptographyException, PlpdfException {
        Object fieldValue = fdfField.getValue();
        int fieldFlags = this.getFieldFlags();
        if (fieldValue != null) {
            if (fieldValue instanceof String) {
                this.setValue((String)fieldValue);
            } else if (fieldValue instanceof SMTextStream) {
                this.setValue(((SMTextStream)fieldValue).getAsString());
            } else {
                throw new IOException("Unknown field type:" + fieldValue.getClass().getName());
            }
        }
        this.acroForm.isXfaPresent();
        Integer ff = fdfField.getFieldFlags();
        if (ff != null) {
            this.setFieldFlags(ff);
        } else {
            Integer clrFf;
            Integer setFf = fdfField.getSetFieldFlags();
            if (setFf != null) {
                int setFfInt = setFf;
                this.setFieldFlags(fieldFlags |= setFfInt);
            }
            if ((clrFf = fdfField.getClearFieldFlags()) != null) {
                int clrFfValue = clrFf;
                this.setFieldFlags(fieldFlags &= (clrFfValue ^= 0xFFFFFFFF));
            }
        }
        SMAnnotationWidget widget = this.getWidget();
        if (widget != null) {
            int annotFlags = widget.getAnnotationFlags();
            Integer f = fdfField.getWidgetFieldFlags();
            if (f != null && widget != null) {
                widget.setAnnotationFlags(f);
            } else {
                Integer clrF;
                Integer setF = fdfField.getSetWidgetFieldFlags();
                if (setF != null) {
                    widget.setAnnotationFlags(annotFlags |= setF.intValue());
                }
                if ((clrF = fdfField.getClearWidgetFieldFlags()) != null) {
                    int clrFValue = clrF;
                    clrFValue = (int)((long)clrFValue ^ 0xFFFFFFFFL);
                    widget.setAnnotationFlags(annotFlags &= clrFValue);
                }
            }
        }
        List<FDFField> fdfKids = fdfField.getKids();
        List<OMObjectable> pdKids = this.getKids();
        int i = 0;
        while (fdfKids != null && i < fdfKids.size()) {
            FDFField fdfChild = fdfKids.get(i);
            String fdfName = fdfChild.getPartialFieldName();
            int j = 0;
            while (j < pdKids.size()) {
                OMObjectable pdChildObj = pdKids.get(j);
                if (pdChildObj instanceof SMField) {
                    SMField pdChild = (SMField)pdChildObj;
                    if (fdfName != null && fdfName.equals(pdChild.getPartialName())) {
                        pdChild.importFDF(fdfChild);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public SMAnnotationWidget getWidget() throws IOException {
        OMObjectable firstKid;
        SMAnnotationWidget retval = null;
        List<OMObjectable> kids = this.getKids();
        retval = kids == null ? new SMAnnotationWidget(this.getDictionary()) : (kids.size() > 0 ? ((firstKid = kids.get(0)) instanceof SMAnnotationWidget ? (SMAnnotationWidget)firstKid : ((SMField)firstKid).getWidget()) : null);
        return retval;
    }

    public SMField getParent() throws IOException {
        SMField parent = null;
        OMDictionary parentDic = (OMDictionary)this.getDictionary().getDictionaryObject(OMName.PARENT, OMName.P);
        if (parentDic != null) {
            parent = SMFieldFactory.createField(this.getAcroForm(), parentDic);
        }
        return parent;
    }

    public void setParent(SMField parent) {
        this.getDictionary().setItem("Parent", (OMObjectable)parent);
    }

    public SMField findKid(String[] name, int nameIndex) throws IOException {
        SMField retval = null;
        OMArray kids = (OMArray)this.getDictionary().getDictionaryObject(OMName.KIDS);
        if (kids != null) {
            int i = 0;
            while (retval == null && i < kids.size()) {
                OMDictionary kidDictionary = (OMDictionary)kids.getObject(i);
                if (name[nameIndex].equals(kidDictionary.getString("T"))) {
                    retval = SMFieldFactory.createField(this.acroForm, kidDictionary);
                    if (name.length > nameIndex + 1) {
                        retval = retval.findKid(name, nameIndex + 1);
                    }
                }
                ++i;
            }
        }
        return retval;
    }

    public List<OMObjectable> getKids____() throws IOException {
        OMArrayList retval = null;
        OMArray kids = (OMArray)this.getDictionary().getDictionaryObject(OMName.KIDS);
        if (kids != null) {
            ArrayList<OMObjectable> kidsList = new ArrayList<OMObjectable>();
            int i = 0;
            while (i < kids.size()) {
                OMDictionary kidDictionary = (OMDictionary)kids.getObject(i);
                OMDictionary parent = (OMDictionary)kidDictionary.getDictionaryObject(OMName.PARENT, OMName.P);
                if (kidDictionary.getDictionaryObject(OMName.FT) != null || parent != null && parent.getDictionaryObject(OMName.FT) != null) {
                    kidsList.add(SMFieldFactory.createField(this.acroForm, kidDictionary));
                } else if ("Widget".equals(kidDictionary.getNameAsString(OMName.SUBTYPE))) {
                    kidsList.add(new SMAnnotationWidget(kidDictionary));
                } else {
                    kidsList.add(SMFieldFactory.createField(this.acroForm, kidDictionary));
                }
                ++i;
            }
            retval = new OMArrayList(kidsList, kids);
        }
        return retval;
    }

    public List<OMObjectable> getKids() throws IOException {
        OMArrayList retval = null;
        OMArray kids = (OMArray)this.getDictionary().getDictionaryObject(OMName.KIDS);
        if (kids != null) {
            ArrayList<OMObjectable> kidsList = new ArrayList<OMObjectable>();
            int i = 0;
            while (i < kids.size()) {
                OMDictionary kidDictionary = (OMDictionary)kids.getObject(i);
                if (kidDictionary != null) {
                    OMDictionary parent = (OMDictionary)kidDictionary.getDictionaryObject(OMName.PARENT, OMName.P);
                    if (kidDictionary.getDictionaryObject(OMName.FT) != null || parent != null && parent.getDictionaryObject(OMName.FT) != null) {
                        kidsList.add(SMFieldFactory.createField(this.acroForm, kidDictionary));
                    } else if ("Widget".equals(kidDictionary.getNameAsString(OMName.SUBTYPE))) {
                        kidsList.add(new SMAnnotationWidget(kidDictionary));
                    } else {
                        kidsList.add(SMFieldFactory.createField(this.acroForm, kidDictionary));
                    }
                }
                ++i;
            }
            retval = new OMArrayList(kidsList, kids);
        }
        return retval;
    }

    public void setKids(List<OMObjectable> kids) {
        OMArray kidsArray = OMArrayList.converterToOMArray(kids);
        this.getDictionary().setItem(OMName.KIDS, (OMBase)kidsArray);
    }

    public String toString() {
        return "" + this.getDictionary().getDictionaryObject(OMName.V);
    }

    public SMAcroForm getAcroForm() {
        return this.acroForm;
    }

    public void setAcroForm(SMAcroForm value) {
        this.acroForm = value;
    }

    public OMDictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public OMBase getOMObject() {
        return this.dictionary;
    }

    public SMFormFieldAdditionalActions getActions() {
        OMDictionary aa = (OMDictionary)this.dictionary.getDictionaryObject(OMName.AA);
        SMFormFieldAdditionalActions retval = null;
        if (aa != null) {
            retval = new SMFormFieldAdditionalActions(aa);
        }
        return retval;
    }

    public void setActions(SMFormFieldAdditionalActions actions) {
        this.dictionary.setItem(OMName.AA, (OMObjectable)actions);
    }

    public void setAction(SMAction action) {
        this.dictionary.setItem("A", (OMObjectable)action);
    }

    public void setPage(SMPage page) {
        this.getDictionary().setItem("P", (OMObjectable)page);
    }

    public void setPage1(SMPage page) throws IOException, PlpdfException {
        this.setPage(page);
        page.addAnnotations(this);
    }

    public void setPage1(SMDocument doc, int pagenum) throws IOException, PlpdfException {
        SMPage page1 = (SMPage)doc.getDocumentCatalog().getAllPages().get(pagenum);
        this.setPage(page1);
        page1.addAnnotations(this);
    }

    public void setAnnotationFlag(int flag) {
        this.getDictionary().setInt("F", flag);
    }

    public void setRectangle(float x, float y, float width, float height) {
        SMRectangle r = new SMRectangle(width, height);
        r.move(x, y);
        this.getDictionary().setItem(OMName.getPDFName("Rect"), (OMBase)r.getOMArray());
    }

    public void setTooltip(String name) throws IOException, PlpdfException {
        this.getDictionary().setString("TU", name);
    }

    public String getTooltip() throws IOException, PlpdfException {
        return this.getDictionary().getString("TU");
    }

    public void setDictionary(OMDictionary dict) {
        this.dictionary = dict;
    }

    public void setFieldType(String fieldtype) {
        this.getDictionary().setName("FT", fieldtype);
    }

    public void setLayer(SMOptionalContentGroup layer) {
        this.getDictionary().setItem("OC", (OMObjectable)layer);
    }

    public void setPushbutton(boolean readonly) {
        BitFlagHelper.setFlag(this.getDictionary(), "Ff", 65536, readonly);
    }

    public abstract String getDefaultValue() throws IOException;
}

