/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.form;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.smmodel.interactive.form.SMVariableText;
import java.io.IOException;

public class SMChoiceField
extends SMVariableText {
    public static final int FLAG_COMBO = 131072;
    public static final int FLAG_EDIT = 262144;

    public SMChoiceField(SMAcroForm theAcroForm, OMDictionary field) {
        super(theAcroForm, field);
    }

    public void setValue(String optionValue) throws IOException, CryptographyException, PlpdfException {
        int fieldFlags;
        boolean isEditable;
        int i;
        int indexSelected = -1;
        OMArray options = (OMArray)this.getDictionary().getDictionaryObject(OMName.OPT);
        if (options == null) {
            OMArray kids = (OMArray)this.getDictionary().getDictionaryObject(OMName.KIDS);
            i = 0;
            while (kids != null && i < kids.size()) {
                OMDictionary kid = (OMDictionary)kids.getObject(i);
                options = (OMArray)kid.getDictionaryObject(OMName.OPT);
                if (options != null) break;
                ++i;
            }
        }
        boolean bl = isEditable = (0x20000 & (fieldFlags = this.getFieldFlags())) != 0 && (0x40000 & fieldFlags) != 0;
        if (options.size() == 0 && !isEditable) {
            throw new IOException("Error: You cannot set a value for a choice field if there are no options.");
        }
        i = 0;
        while (i < options.size() && indexSelected == -1) {
            OMBase option = options.getObject(i);
            if (option instanceof OMArray) {
                OMArray keyValuePair = (OMArray)option;
                OMString key = (OMString)keyValuePair.getObject(0);
                OMString value = (OMString)keyValuePair.getObject(1);
                if (optionValue.equals(key.getString()) || optionValue.equals(value.getString())) {
                    super.setValue(value.getString());
                    this.getDictionary().setItem(OMName.V, (OMBase)key);
                    indexSelected = i;
                }
            } else {
                OMString value = (OMString)option;
                if (optionValue.equals(value.getString())) {
                    super.setValue(optionValue);
                    indexSelected = i;
                }
            }
            ++i;
        }
        if (indexSelected == -1 && isEditable) {
            super.setValue(optionValue);
        } else {
            if (indexSelected == -1) {
                throw new IOException("Error: '" + optionValue + "' was not an available option.");
            }
            OMArray indexArray = (OMArray)this.getDictionary().getDictionaryObject(OMName.I);
            if (indexArray != null) {
                indexArray.clear();
                indexArray.add(OMInteger.get(indexSelected));
            }
        }
    }
}

