/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.form;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.smmodel.interactive.form.SMChoiceButton;
import java.io.IOException;

public class SMCheckbox
extends SMChoiceButton {
    private static final OMName KEY = OMName.getPDFName("AS");
    private static final OMName OFF_VALUE = OMName.getPDFName("Off");
    private OMName value;

    public SMCheckbox(SMAcroForm theAcroForm, OMDictionary field) {
        super(theAcroForm, field);
        OMDictionary ap = (OMDictionary)field.getDictionaryObject(OMName.getPDFName("AP"));
        if (ap != null) {
            OMBase n = ap.getDictionaryObject(OMName.getPDFName("N"));
            if (n instanceof OMDictionary) {
                for (OMName name : ((OMDictionary)n).keySet()) {
                    if (name.equals(OFF_VALUE)) continue;
                    this.value = name;
                }
            }
        } else {
            this.value = (OMName)this.getDictionary().getDictionaryObject("V");
        }
    }

    public boolean isChecked() {
        boolean retval = false;
        String onValue = this.getOnValue();
        OMName radioValue = (OMName)this.getDictionary().getDictionaryObject(KEY);
        if (radioValue != null && this.value != null && radioValue.getName().equals(onValue)) {
            retval = true;
        }
        return retval;
    }

    public void check() {
        this.getDictionary().setItem(KEY, (OMBase)this.value);
    }

    public void unCheck() {
        this.getDictionary().setItem(KEY, (OMBase)OFF_VALUE);
    }

    public void setValue(String newValue) {
        this.getDictionary().setName("V", newValue);
        if (newValue == null) {
            this.getDictionary().setItem(KEY, (OMBase)OFF_VALUE);
        } else {
            this.getDictionary().setName(KEY, newValue);
        }
    }

    public String getOffValue() {
        return OFF_VALUE.getName();
    }

    public String getOnValue() {
        String retval = null;
        OMDictionary ap = (OMDictionary)this.getDictionary().getDictionaryObject(OMName.getPDFName("AP"));
        OMBase n = ap.getDictionaryObject(OMName.getPDFName("N"));
        if (n instanceof OMDictionary) {
            for (OMName key : ((OMDictionary)n).keySet()) {
                if (key.equals(OFF_VALUE)) continue;
                retval = key.getName();
            }
        }
        return retval;
    }

    public String getValue() throws IOException {
        return this.getDictionary().getNameAsString("V");
    }

    public String getDefaultValue() throws IOException {
        return null;
    }
}

