/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.form;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMStream;
import com.plpdf.om.OMString;
import com.plpdf.pdfparser.PDFStreamParser;
import com.plpdf.pdfwriter.ContentStreamWriter;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.font.SMFont;
import com.plpdf.smmodel.font.SMFontDescriptor;
import com.plpdf.smmodel.font.SMSimpleFont;
import com.plpdf.smmodel.interactive.action.SMFormFieldAdditionalActions;
import com.plpdf.smmodel.interactive.annotation.SMAnnotationWidget;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceDictionary;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceStream;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.smmodel.interactive.form.SMField;
import com.plpdf.smmodel.interactive.form.SMVariableText;
import com.plpdf.util.PDFOperator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SMAppearance {
    private static final String CLASS_NAME = SMAppearance.class.getName();
    private SMVariableText parent;
    private String value;
    private OMString defaultAppearance;
    private SMAcroForm acroForm;
    private List<OMObjectable> widgets = new ArrayList<OMObjectable>();
    private boolean multiline = false;
    private String apValue;

    public SMAppearance(SMAcroForm theAcroForm, SMVariableText field) throws IOException {
        this.acroForm = theAcroForm;
        this.parent = field;
        this.widgets = field.getKids();
        if (this.widgets == null) {
            this.widgets = new ArrayList<OMObjectable>();
            this.widgets.add(field.getWidget());
        }
        this.defaultAppearance = this.getDefaultAppearance();
    }

    private OMString getDefaultAppearance() {
        OMString dap = this.parent.getDefaultAppearance();
        if (dap == null) {
            OMArray kids = (OMArray)this.parent.getDictionary().getDictionaryObject(OMName.KIDS);
            if (kids != null && kids.size() > 0) {
                OMDictionary firstKid = (OMDictionary)kids.getObject(0);
                dap = (OMString)firstKid.getDictionaryObject(OMName.DA);
            }
            if (dap == null) {
                dap = (OMString)this.acroForm.getDictionary().getDictionaryObject(OMName.DA);
            }
        }
        return dap;
    }

    private int getQ() {
        OMDictionary firstKid;
        OMNumber qNum;
        OMArray kids;
        int q = this.parent.getQ();
        if (this.parent.getDictionary().getDictionaryObject(OMName.Q) == null && (kids = (OMArray)this.parent.getDictionary().getDictionaryObject(OMName.KIDS)) != null && kids.size() > 0 && (qNum = (OMNumber)(firstKid = (OMDictionary)kids.getObject(0)).getDictionaryObject(OMName.Q)) != null) {
            q = qNum.intValue();
        }
        return q;
    }

    private List getStreamTokens(SMAppearanceStream appearanceStream) throws IOException, CryptographyException {
        List tokens = null;
        if (appearanceStream != null) {
            tokens = this.getStreamTokens(appearanceStream.getStream());
        }
        return tokens;
    }

    private List getStreamTokens(OMString string) throws IOException, CryptographyException {
        List<Object> tokens = null;
        if (string != null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes());
            PDFStreamParser parser = new PDFStreamParser((InputStream)stream, this.acroForm.getDocument().getDocument().getScratchFile());
            parser.parse();
            tokens = parser.getTokens();
        }
        return tokens;
    }

    private List getStreamTokens(OMStream stream) throws IOException, CryptographyException {
        List<Object> tokens = null;
        if (stream != null) {
            PDFStreamParser parser = new PDFStreamParser(stream);
            parser.parse();
            tokens = parser.getTokens();
        }
        return tokens;
    }

    private boolean containsMarkedContent(List stream) {
        return stream.contains(PDFOperator.getOperator("BMC"));
    }

    public void setAppearanceValue(String apValue1) throws IOException, CryptographyException, PlpdfException {
        this.apValue = apValue1;
        for (OMObjectable next : this.widgets) {
            ContentStreamWriter writer;
            ByteArrayOutputStream output;
            Map<String, SMAppearanceStream> normalAppearance;
            SMAppearanceStream appearanceStream;
            SMField field = null;
            SMAnnotationWidget widget = null;
            if (next instanceof SMField) {
                field = (SMField)next;
                widget = field.getWidget();
            } else {
                widget = (SMAnnotationWidget)next;
            }
            SMFormFieldAdditionalActions actions = null;
            if (field != null) {
                actions = field.getActions();
            }
            if (actions != null && actions.getF() != null && widget.getDictionary().getDictionaryObject(OMName.AP) == null) continue;
            SMAppearanceDictionary appearance = widget.getAppearance();
            if (appearance == null) {
                appearance = new SMAppearanceDictionary();
                widget.setAppearance(appearance);
            }
            if ((appearanceStream = (normalAppearance = appearance.getNormalAppearance()).get("default")) == null) {
                OMStream omStream = this.acroForm.getDocument().getDocument().createOMStream();
                appearanceStream = new SMAppearanceStream(omStream);
                appearanceStream.setBoundingBox(widget.getRectangle().createRetranslatedRectangle());
                appearance.setNormalAppearance(appearanceStream);
            }
            List tokens = this.getStreamTokens(appearanceStream);
            List daTokens = this.getStreamTokens(this.getDefaultAppearance());
            SMFont pdFont = this.getFontAndUpdateResources(tokens, appearanceStream);
            if (!this.containsMarkedContent(tokens)) {
                output = new ByteArrayOutputStream();
                writer = new ContentStreamWriter(output);
                writer.writeTokens(tokens);
                output.write(" /Tx BMC\n".getBytes("ISO-8859-1"));
                output.write(" q\n".getBytes("ISO-8859-1"));
                this.insertGeneratedAppearance(widget, output, pdFont, tokens, appearanceStream);
                output.write(" Q\n".getBytes("ISO-8859-1"));
                output.write(" EMC".getBytes("ISO-8859-1"));
                this.writeToStream(output.toByteArray(), appearanceStream);
            } else if (tokens != null) {
                if (daTokens != null) {
                    int bmcIndex = tokens.indexOf(PDFOperator.getOperator("BMC"));
                    int emcIndex = tokens.indexOf(PDFOperator.getOperator("EMC"));
                    if (bmcIndex != -1 && emcIndex != -1 && emcIndex == bmcIndex + 1) {
                        tokens.addAll(emcIndex, daTokens);
                    }
                }
                output = new ByteArrayOutputStream();
                writer = new ContentStreamWriter(output);
                float fontSize = this.calculateFontSize(pdFont, appearanceStream.getBoundingBox(), tokens, daTokens);
                this.value = this.parent.isMultiline() && (this.apValue.indexOf(10) != -1 || this.apValue.indexOf(13) != -1) ? this.convertToMultiLine(this.apValue, fontSize) : this.apValue;
                boolean foundString = false;
                int i = 0;
                while (i < tokens.size()) {
                    if (tokens.get(i) instanceof OMString) {
                        foundString = true;
                        OMString drawnString = (OMString)tokens.get(i);
                        drawnString.reset();
                        drawnString.append(this.value.getBytes("ISO-8859-1"));
                    }
                    ++i;
                }
                int setFontIndex = tokens.indexOf(PDFOperator.getOperator("Tf"));
                tokens.set(setFontIndex - 1, new OMFloat(fontSize));
                if (foundString) {
                    writer.writeTokens(tokens);
                } else {
                    int bmcIndex = tokens.indexOf(PDFOperator.getOperator("BMC"));
                    int emcIndex = tokens.indexOf(PDFOperator.getOperator("EMC"));
                    if (bmcIndex != -1) {
                        writer.writeTokens(tokens, 0, bmcIndex + 1);
                    } else {
                        writer.writeTokens(tokens);
                    }
                    output.write("\n".getBytes("ISO-8859-1"));
                    this.insertGeneratedAppearance(widget, output, pdFont, tokens, appearanceStream);
                    if (emcIndex != -1) {
                        writer.writeTokens(tokens, emcIndex, tokens.size());
                    }
                }
                this.writeToStream(output.toByteArray(), appearanceStream);
            }
            if (appearanceStream == null) continue;
            ArrayList<OMName> filters = new ArrayList<OMName>();
            filters.add(OMName.FLATE_DECODE);
            appearanceStream.setFilters(filters);
        }
    }

    private void insertGeneratedAppearance(SMAnnotationWidget fieldWidget, OutputStream output, SMFont pdFont, List tokens, SMAppearanceStream appearanceStream) throws IOException, CryptographyException, PlpdfException {
        PrintWriter printWriter = new PrintWriter(output, true);
        float fontSize = 0.0f;
        SMRectangle boundingBox = null;
        boundingBox = appearanceStream.getBoundingBox();
        if (boundingBox == null) {
            boundingBox = fieldWidget.getRectangle().createRetranslatedRectangle();
        }
        printWriter.println("BT");
        if (this.defaultAppearance != null) {
            String daString = this.defaultAppearance.getString();
            PDFStreamParser daParser = new PDFStreamParser((InputStream)new ByteArrayInputStream(daString.getBytes("ISO-8859-1")), null);
            daParser.parse();
            List<Object> daTokens = daParser.getTokens();
            fontSize = this.calculateFontSize(pdFont, boundingBox, tokens, daTokens);
            this.value = this.parent.isMultiline() && (this.apValue.indexOf(10) != -1 || this.apValue.indexOf(13) != -1) ? this.convertToMultiLine(this.apValue, fontSize) : this.apValue;
            int fontIndex = daTokens.indexOf(PDFOperator.getOperator("Tf"));
            if (fontIndex != -1) {
                daTokens.set(fontIndex - 1, new OMFloat(fontSize));
            }
            ContentStreamWriter daWriter = new ContentStreamWriter(output);
            daWriter.writeTokens(daTokens);
        }
        printWriter.println(this.getTextPosition(boundingBox, pdFont, fontSize, tokens));
        int q = this.getQ();
        if (q != 0) {
            if (q == 1 || q == 2) {
                float fieldWidth = boundingBox.getWidth();
                float stringWidth = pdFont.getStringWidth(this.value) / 1000.0f * fontSize;
                float adjustAmount = fieldWidth - stringWidth - 4.0f;
                if (q == 1) {
                    adjustAmount /= 2.0f;
                }
                printWriter.println(String.valueOf(adjustAmount) + " 0 Td");
            } else {
                throw new PlpdfException(CLASS_NAME, "UnknownJustificationValue", new String[]{String.valueOf(q)});
            }
        }
        this.value = this.parent.isMultiline() && (this.apValue.indexOf(10) != -1 || this.apValue.indexOf(13) != -1) ? this.convertToMultiLine(this.apValue, fontSize) : this.apValue;
        if (this.multiline) {
            printWriter.println(" " + this.value + " Tj");
        } else {
            String enc = this.acroForm.getClientEncoding();
            this.drawString(pdFont, printWriter, this.value, enc);
        }
        printWriter.println("ET");
        printWriter.flush();
    }

    public void drawString(SMFont font, PrintWriter printWriter, String text, String enc) throws IOException, PlpdfException {
        if (enc == null) {
            enc = "ISO-8859-1";
        }
        OMString string = new OMString(text, enc);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        string.writePDF(buffer);
        printWriter.print(new String(buffer.toByteArray(), enc));
        printWriter.println(" Tj");
    }

    private SMFont getFontAndUpdateResources(List tokens, SMAppearanceStream appearanceStream) throws IOException, CryptographyException {
        SMFont retval = null;
        SMResources streamResources = appearanceStream.getResources();
        SMResources formResources = this.acroForm.getDefaultResources();
        if (formResources != null) {
            OMString da;
            if (streamResources == null) {
                streamResources = new SMResources();
                appearanceStream.setResources(streamResources);
            }
            if ((da = this.getDefaultAppearance()) != null) {
                String data = da.getString();
                PDFStreamParser streamParser = new PDFStreamParser((InputStream)new ByteArrayInputStream(data.getBytes("ISO-8859-1")), null);
                streamParser.parse();
                tokens = streamParser.getTokens();
            }
            int setFontIndex = tokens.indexOf(PDFOperator.getOperator("Tf"));
            OMName cosFontName = (OMName)tokens.get(setFontIndex - 2);
            String fontName = cosFontName.getName();
            retval = streamResources.getFonts().get(fontName);
            if (retval == null) {
                retval = formResources.getFonts().get(fontName);
                streamResources.addFont(retval, fontName);
            }
        }
        return retval;
    }

    private String convertToMultiLine(String line, float fs) throws IOException, PlpdfException {
        this.multiline = false;
        NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);
        int currIdx = 0;
        int lastIdx = 0;
        StringBuffer result = new StringBuffer(line.length() + 64);
        while ((currIdx = line.indexOf(10, lastIdx)) > -1) {
            result.append(this.getString(String.valueOf(line.substring(lastIdx, currIdx)) + " "));
            result.append(" Tj\n0 -" + formatDecimal.format(fs) + " Td\n ");
            lastIdx = currIdx + 1;
            this.multiline = true;
        }
        while ((currIdx = line.indexOf(13, lastIdx)) > -1) {
            result.append(this.getString(line.substring(lastIdx, currIdx)));
            result.append(" Tj\n0 -" + formatDecimal.format(fs) + " Td\n ");
            lastIdx = currIdx + 1;
            this.multiline = true;
        }
        result.append(this.getString(line.substring(lastIdx)));
        return result.toString();
    }

    public String getString(String text) throws IOException, PlpdfException {
        String enc = this.acroForm.getClientEncoding();
        if (enc == null) {
            enc = "ISO-8859-1";
        }
        OMString string = new OMString(text, enc);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        string.writePDF(buffer);
        String s = new String(buffer.toByteArray(), enc);
        return s;
    }

    private void writeToStream(byte[] data, SMAppearanceStream appearanceStream) throws IOException {
        OutputStream out = appearanceStream.getStream().createUnfilteredStream();
        out.write(data);
        out.flush();
    }

    private float getLineWidth(List tokens) {
        float retval = 1.0f;
        if (tokens != null) {
            int btIndex = tokens.indexOf(PDFOperator.getOperator("BT"));
            int wIndex = tokens.indexOf(PDFOperator.getOperator("w"));
            if (wIndex > 0 && wIndex < btIndex) {
                retval = ((OMNumber)tokens.get(wIndex - 1)).floatValue();
            }
        }
        return retval;
    }

    private SMRectangle getSmallestDrawnRectangle(SMRectangle boundingBox, List tokens) {
        SMRectangle smallest = boundingBox;
        int i = 0;
        while (i < tokens.size()) {
            Object next = tokens.get(i);
            if (next == PDFOperator.getOperator("re")) {
                OMNumber x = (OMNumber)tokens.get(i - 4);
                OMNumber y = (OMNumber)tokens.get(i - 3);
                OMNumber width = (OMNumber)tokens.get(i - 2);
                OMNumber height = (OMNumber)tokens.get(i - 1);
                SMRectangle potentialSmallest = new SMRectangle();
                potentialSmallest.setLowerLeftX(x.floatValue());
                potentialSmallest.setLowerLeftY(y.floatValue());
                potentialSmallest.setUpperRightX(x.floatValue() + width.floatValue());
                potentialSmallest.setUpperRightY(y.floatValue() + height.floatValue());
                if (smallest == null || smallest.getLowerLeftX() < potentialSmallest.getLowerLeftX() || smallest.getUpperRightY() > potentialSmallest.getUpperRightY()) {
                    smallest = potentialSmallest;
                }
            }
            ++i;
        }
        return smallest;
    }

    private float calculateFontSize(SMFont pdFont, SMRectangle boundingBox, List tokens, List daTokens) throws IOException {
        int fontIndex;
        float fontSize = 0.0f;
        if (daTokens != null && (fontIndex = daTokens.indexOf(PDFOperator.getOperator("Tf"))) != -1) {
            fontSize = ((OMNumber)daTokens.get(fontIndex - 1)).floatValue();
        }
        float widthBasedFontSize = Float.MAX_VALUE;
        if (this.parent.doNotScroll()) {
            float widthAtFontSize1 = pdFont.getStringWidth(this.apValue) / 1000.0f;
            float availableWidth = this.getAvailableWidth(boundingBox, this.getLineWidth(tokens));
            widthBasedFontSize = availableWidth / widthAtFontSize1;
        }
        if (fontSize == 0.0f) {
            float lineWidth = this.getLineWidth(tokens);
            float stringWidth = pdFont.getStringWidth(this.apValue);
            float height = 0.0f;
            height = pdFont instanceof SMSimpleFont ? ((SMSimpleFont)pdFont).getFontDescriptor().getFontBoundingBox().getHeight() : pdFont.getAverageFontWidth();
            float availHeight = this.getAvailableHeight(boundingBox, lineWidth);
            fontSize = Math.min(availHeight / (height /= 1000.0f), widthBasedFontSize);
        }
        return fontSize;
    }

    private String getTextPosition(SMRectangle boundingBox, SMFont pdFont, float fontSize, List tokens) throws IOException {
        float lineWidth = this.getLineWidth(tokens);
        float pos = 0.0f;
        if (this.parent.isMultiline()) {
            int rows = (int)(this.getAvailableHeight(boundingBox, lineWidth) / (float)((int)fontSize));
            pos = (float)rows * fontSize - fontSize;
        } else if (pdFont instanceof SMSimpleFont) {
            SMFontDescriptor fd = ((SMSimpleFont)pdFont).getFontDescriptor();
            float bBoxHeight = boundingBox.getHeight();
            float fontHeight = fd.getFontBoundingBox().getHeight() + 2.0f * fd.getDescent();
            fontHeight = fontHeight / 1000.0f * fontSize;
            pos = (bBoxHeight - fontHeight) / 2.0f;
        } else {
            throw new IOException("Error: Don't know how to calculate the position for non-simple fonts");
        }
        SMRectangle innerBox = this.getSmallestDrawnRectangle(boundingBox, tokens);
        float xInset = 2.0f + 2.0f * (boundingBox.getWidth() - innerBox.getWidth());
        return String.valueOf(Math.round(xInset)) + " " + pos + " Td";
    }

    private float getAvailableWidth(SMRectangle boundingBox, float lineWidth) {
        return boundingBox.getWidth() - 2.0f * lineWidth;
    }

    private float getAvailableHeight(SMRectangle boundingBox, float lineWidth) {
        return boundingBox.getHeight() - 2.0f * lineWidth;
    }
}

