/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.form;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.OMArrayList;
import com.plpdf.smmodel.common.OMDictionaryMap;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.fdf.FDFCatalog;
import com.plpdf.smmodel.fdf.FDFDictionary;
import com.plpdf.smmodel.fdf.FDFDocument;
import com.plpdf.smmodel.fdf.FDFField;
import com.plpdf.smmodel.font.SMFont;
import com.plpdf.smmodel.font.SMFontFactory;
import com.plpdf.smmodel.interactive.form.SMField;
import com.plpdf.smmodel.interactive.form.SMFieldFactory;
import com.plpdf.smmodel.interactive.form.SMXFA;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMAcroForm
implements OMObjectable {
    private OMDictionary acroForm;
    private SMDocument document;
    private Map fieldCache;
    private boolean xfaPresent;
    private SMXFA xfa;
    private String clientEncoding;

    public SMAcroForm(SMDocument doc) {
        this.document = doc;
        this.acroForm = new OMDictionary();
        OMArray fields = new OMArray();
        this.acroForm.setItem(OMName.getPDFName("Fields"), (OMBase)fields);
    }

    public SMAcroForm(SMDocument doc, OMDictionary form) {
        this.document = doc;
        this.acroForm = form;
    }

    public SMDocument getDocument() {
        return this.document;
    }

    public OMDictionary getDictionary() {
        return this.acroForm;
    }

    public void importFDF(FDFDocument fdf) throws IOException, CryptographyException, PlpdfException {
        List fields = fdf.getCatalog().getFDF().getFields();
        if (fields != null) {
            int i = 0;
            while (i < fields.size()) {
                FDFField fdfField = (FDFField)fields.get(i);
                SMField docField = this.getField(fdfField.getPartialFieldName());
                if (docField != null) {
                    docField.importFDF(fdfField);
                }
                ++i;
            }
        }
    }

    public FDFDocument exportFDF() throws IOException, PlpdfException {
        return this.exportFDF(false);
    }

    public FDFDocument exportFDF(boolean exportnull) throws IOException, PlpdfException {
        FDFDocument fdf = new FDFDocument();
        FDFCatalog catalog = fdf.getCatalog();
        FDFDictionary fdfDict = new FDFDictionary();
        catalog.setFDF(fdfDict);
        ArrayList fdfFields = new ArrayList();
        List<SMField> fields = this.getFields();
        for (SMField docField : fields) {
            this.addFieldAndChildren(docField, fdfFields, exportnull);
        }
        fdfDict.setID(this.document.getDocument().getDocumentID());
        if (fdfFields.size() > 0) {
            fdfDict.setFields(fdfFields);
        }
        return fdf;
    }

    private void addFieldAndChildren(SMField docField, List fdfFields, boolean exportnull) throws IOException, PlpdfException {
        String fieldValue = docField.getValue();
        FDFField fdfField = new FDFField();
        fdfField.setPartialFieldName(docField.getPartialName());
        fdfField.setValue(fieldValue, docField.getFieldType());
        List<OMObjectable> kids = docField.getKids();
        ArrayList<FDFField> childFDFFields = new ArrayList<FDFField>();
        if (kids != null) {
            int i = 0;
            while (i < kids.size()) {
                this.addFieldAndChildren((SMField)kids.get(i), childFDFFields, exportnull);
                ++i;
            }
            if (childFDFFields.size() > 0) {
                fdfField.setKids(childFDFFields);
            }
        }
        if (fieldValue != null || childFDFFields.size() > 0 || exportnull) {
            fdfFields.add(fdfField);
        }
    }

    public List<SMField> getFields() throws IOException {
        OMArrayList retval = null;
        OMArray fields = (OMArray)this.acroForm.getDictionaryObject(OMName.getPDFName("Fields"));
        if (fields != null) {
            ArrayList<SMField> actuals = new ArrayList<SMField>();
            int i = 0;
            while (i < fields.size()) {
                SMField field;
                OMDictionary element = (OMDictionary)fields.getObject(i);
                if (element != null && (field = SMFieldFactory.createField(this, element)) != null) {
                    actuals.add(field);
                }
                ++i;
            }
            retval = new OMArrayList(actuals, fields);
        }
        return retval;
    }

    public void setFields(List fields) {
        this.acroForm.setItem("Fields", (OMBase)OMArrayList.converterToOMArray(fields));
    }

    public void setCacheFields(boolean cache) throws IOException {
        if (cache) {
            this.fieldCache = new HashMap();
            List<SMField> fields = this.getFields();
            for (SMField next : fields) {
                this.fieldCache.put(next.getFullyQualifiedName(), next);
            }
        } else {
            this.fieldCache = null;
        }
    }

    public boolean isCachingFields() {
        return this.fieldCache != null;
    }

    public SMField getField(String name) throws IOException {
        SMField retval = null;
        if (this.fieldCache != null) {
            retval = (SMField)this.fieldCache.get(name);
        } else {
            String[] nameSubSection = name.split("\\.");
            OMArray fields = (OMArray)this.acroForm.getDictionaryObject(OMName.getPDFName("Fields"));
            int i = 0;
            while (i < fields.size() && retval == null) {
                OMString fieldName;
                OMDictionary element = (OMDictionary)fields.getObject(i);
                if (element != null && ((fieldName = (OMString)element.getDictionaryObject(OMName.getPDFName("T"))).getString().equals(name) || fieldName.getString().equals(nameSubSection[0]))) {
                    SMField kid;
                    SMField root = SMFieldFactory.createField(this, element);
                    retval = nameSubSection.length > 1 ? ((kid = root.findKid(nameSubSection, 1)) != null ? kid : root) : root;
                }
                ++i;
            }
        }
        return retval;
    }

    public SMResources getDefaultResources() {
        SMResources retval = null;
        OMDictionary dr = (OMDictionary)this.acroForm.getDictionaryObject(OMName.getPDFName("DR"));
        if (dr != null) {
            retval = new SMResources(dr);
        }
        return retval;
    }

    public void setDefaultResources(SMResources dr) {
        OMDictionary drDict = null;
        if (dr != null) {
            drDict = dr.getOMDictionary();
        }
        this.acroForm.setItem(OMName.getPDFName("DR"), (OMBase)drDict);
    }

    @Override
    public OMBase getOMObject() {
        return this.acroForm;
    }

    public void getXFA() throws PlpdfException, IOException {
        OMBase base = this.acroForm.getDictionaryObject("XFA");
        if (base != null) {
            this.xfa = new SMXFA(base);
            this.xfaPresent = true;
        } else {
            this.xfaPresent = false;
        }
    }

    public void setXFA(SMXFA xfa) {
        this.acroForm.setItem("XFA", (OMObjectable)xfa);
    }

    public boolean isXfaPresent() {
        return this.xfaPresent;
    }

    public void setXfaPresent(boolean xfaPresent) {
        this.xfaPresent = xfaPresent;
    }

    public void fillXfaForm(Element e) throws Exception {
        this.xfa.fillXfaForm(e);
        this.xfa.writeXFAForm();
    }

    public Map getFonts() throws IOException, PlpdfException {
        OMDictionary dr = this.getDefaultResources().getOMDictionary();
        OMDictionary fonts = (OMDictionary)dr.getDictionaryObject(OMName.FONT);
        if (fonts == null) {
            fonts = new OMDictionary();
            dr.setItem(OMName.FONT, (OMBase)fonts);
        }
        HashMap<String, SMFont> actuals = new HashMap<String, SMFont>();
        for (OMName fontName : fonts.keyList()) {
            OMBase font = fonts.getDictionaryObject(fontName);
            if (!(font instanceof OMDictionary)) continue;
            OMDictionary fontDictionary = (OMDictionary)font;
            actuals.put(fontName.getName(), SMFontFactory.createFont(fontDictionary, null));
        }
        return actuals;
    }

    public void setFonts(Map fonts) {
        this.getDefaultResources().getOMDictionary().setItem(OMName.FONT, (OMBase)OMDictionaryMap.convert(fonts));
    }

    public String getClientEncoding() {
        return this.clientEncoding;
    }

    public void setClientEncoding(String clientEncoding) {
        this.clientEncoding = clientEncoding;
    }

    public void setFieldsReadonly() throws IOException, PlpdfException {
        List<SMField> fields = this.getFields();
        for (SMField docField : fields) {
            this.setFieldAndChildrenReadonly(docField);
        }
    }

    private void setFieldAndChildrenReadonly(SMField docField) throws IOException, PlpdfException {
        docField.setReadonly(true);
        List<OMObjectable> kids = docField.getKids();
        if (kids != null) {
            int i = 0;
            while (i < kids.size()) {
                this.setFieldAndChildrenReadonly((SMField)kids.get(i));
                ++i;
            }
        }
    }
}

