/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.documentnavigation.outline;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.interactive.documentnavigation.outline.SMDocumentOutline;
import com.plpdf.smmodel.interactive.documentnavigation.outline.SMOutlineItem;

public class SMOutlineNode
implements OMObjectable {
    protected OMDictionary node;

    public SMOutlineNode() {
        this.node = new OMDictionary();
    }

    public SMOutlineNode(OMDictionary dict) {
        this.node = dict;
    }

    public OMBase getOMObject() {
        return this.node;
    }

    public OMDictionary getOMDictionary() {
        return this.node;
    }

    protected SMOutlineNode getParent() {
        SMOutlineNode retval = null;
        OMDictionary parent = (OMDictionary)this.node.getDictionaryObject("Parent", "P");
        if (parent != null) {
            retval = parent.getDictionaryObject("Parent", "P") == null ? new SMDocumentOutline(parent) : new SMOutlineItem(parent);
        }
        return retval;
    }

    protected void setParent(SMOutlineNode parent) {
        this.node.setItem("Parent", (OMObjectable)parent);
    }

    public void appendChild(SMOutlineItem outlineNode) {
        outlineNode.setParent(this);
        if (this.getFirstChild() == null) {
            int currentOpenCount = this.getOpenCount();
            this.setFirstChild(outlineNode);
            int numberOfOpenNodesWeAreAdding = 1;
            if (outlineNode.isNodeOpen()) {
                numberOfOpenNodesWeAreAdding += outlineNode.getOpenCount();
            }
            if (this.isNodeOpen()) {
                this.setOpenCount(currentOpenCount + numberOfOpenNodesWeAreAdding);
            } else {
                this.setOpenCount(currentOpenCount - numberOfOpenNodesWeAreAdding);
            }
            this.updateParentOpenCount(numberOfOpenNodesWeAreAdding);
        } else {
            SMOutlineItem previousLastChild = this.getLastChild();
            previousLastChild.insertSiblingAfter(outlineNode);
        }
        SMOutlineItem lastNode = outlineNode;
        while (lastNode.getNextSibling() != null) {
            lastNode = lastNode.getNextSibling();
        }
        this.setLastChild(lastNode);
    }

    public SMOutlineItem getFirstChild() {
        SMOutlineItem last = null;
        OMDictionary lastDic = (OMDictionary)this.node.getDictionaryObject("First");
        if (lastDic != null) {
            last = new SMOutlineItem(lastDic);
        }
        return last;
    }

    protected void setFirstChild(SMOutlineNode outlineNode) {
        this.node.setItem("First", (OMObjectable)outlineNode);
    }

    public SMOutlineItem getLastChild() {
        SMOutlineItem last = null;
        OMDictionary lastDic = (OMDictionary)this.node.getDictionaryObject("Last");
        if (lastDic != null) {
            last = new SMOutlineItem(lastDic);
        }
        return last;
    }

    protected void setLastChild(SMOutlineNode outlineNode) {
        this.node.setItem("Last", (OMObjectable)outlineNode);
    }

    public int getOpenCount() {
        return this.node.getInt("Count", 0);
    }

    protected void setOpenCount(int openCount) {
        this.node.setInt("Count", openCount);
    }

    public void openNode() {
        if (!this.isNodeOpen()) {
            int openChildrenCount = 0;
            SMOutlineItem currentChild = this.getFirstChild();
            while (currentChild != null) {
                ++openChildrenCount;
                if (currentChild.isNodeOpen()) {
                    openChildrenCount += currentChild.getOpenCount();
                }
                currentChild = currentChild.getNextSibling();
            }
            this.setOpenCount(openChildrenCount);
            this.updateParentOpenCount(openChildrenCount);
        }
    }

    public void closeNode() {
        if (this.isNodeOpen()) {
            int openCount = this.getOpenCount();
            this.updateParentOpenCount(-openCount);
            this.setOpenCount(-openCount);
        }
    }

    public boolean isNodeOpen() {
        return this.getOpenCount() > 0;
    }

    protected void updateParentOpenCount(int amount) {
        SMOutlineNode parent = this.getParent();
        if (parent != null) {
            int currentCount = parent.getOpenCount();
            boolean negative = currentCount < 0 || parent.getOMDictionary().getDictionaryObject("Count") == null;
            currentCount = Math.abs(currentCount);
            currentCount += amount;
            if (negative) {
                currentCount = -currentCount;
            }
            parent.setOpenCount(currentCount);
            if (!negative) {
                parent.updateParentOpenCount(amount);
            }
        }
    }
}

