/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.documentnavigation.outline;

import com.plpdf.exceptions.OutlineNotLocalException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.SMDestinationNameTreeNode;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMDocumentNameDictionary;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.documentinterchange.logicalstructure.SMStructureElement;
import com.plpdf.smmodel.graphics.color.SMColorState;
import com.plpdf.smmodel.graphics.color.SMDeviceRGB;
import com.plpdf.smmodel.interactive.action.SMActionFactory;
import com.plpdf.smmodel.interactive.action.type.SMAction;
import com.plpdf.smmodel.interactive.action.type.SMActionGoTo;
import com.plpdf.smmodel.interactive.documentnavigation.destination.SMDestination;
import com.plpdf.smmodel.interactive.documentnavigation.destination.SMNamedDestination;
import com.plpdf.smmodel.interactive.documentnavigation.destination.SMPageDestination;
import com.plpdf.smmodel.interactive.documentnavigation.destination.SMPageXYZDestination;
import com.plpdf.smmodel.interactive.documentnavigation.outline.SMOutlineNode;
import com.plpdf.util.BitFlagHelper;
import java.awt.Color;
import java.io.IOException;
import java.util.List;

public class SMOutlineItem
extends SMOutlineNode {
    private static final int ITALIC_FLAG = 1;
    private static final int BOLD_FLAG = 2;

    public SMOutlineItem() {
    }

    public SMOutlineItem(OMDictionary dic) {
        super(dic);
    }

    public void insertSiblingAfter(SMOutlineItem item) {
        item.setParent(this.getParent());
        SMOutlineItem next = this.getNextSibling();
        this.setNextSibling(item);
        item.setPreviousSibling(this);
        if (next != null) {
            item.setNextSibling(next);
            next.setPreviousSibling(item);
        }
        this.updateParentOpenCount(1);
    }

    public SMOutlineNode getParent() {
        return super.getParent();
    }

    public SMOutlineItem getPreviousSibling() {
        SMOutlineItem last = null;
        OMDictionary lastDic = (OMDictionary)this.node.getDictionaryObject(OMName.PREV);
        if (lastDic != null) {
            last = new SMOutlineItem(lastDic);
        }
        return last;
    }

    protected void setPreviousSibling(SMOutlineNode outlineNode) {
        this.node.setItem(OMName.PREV, (OMObjectable)outlineNode);
    }

    public SMOutlineItem getNextSibling() {
        SMOutlineItem last = null;
        OMDictionary lastDic = (OMDictionary)this.node.getDictionaryObject(OMName.NEXT);
        if (lastDic != null) {
            last = new SMOutlineItem(lastDic);
        }
        return last;
    }

    protected void setNextSibling(SMOutlineNode outlineNode) {
        this.node.setItem(OMName.NEXT, (OMObjectable)outlineNode);
    }

    public String getTitle() {
        return this.node.getString(OMName.TITLE);
    }

    public void setTitle(String title) throws IOException {
        this.node.setString(OMName.TITLE, title);
    }

    public SMDestination getDestination() throws IOException {
        return SMDestination.create(this.node.getDictionaryObject(OMName.DEST));
    }

    public void setDestination(SMDestination dest) {
        this.node.setItem(OMName.DEST, (OMObjectable)dest);
    }

    public void setDestination(SMPage page) {
        SMPageXYZDestination dest = null;
        if (page != null) {
            dest = new SMPageXYZDestination();
            dest.setPage(page);
        }
        this.setDestination(dest);
    }

    public SMPage findDestinationPage(SMDocument doc) throws IOException {
        int pageNumber;
        SMPage page = null;
        SMDestination rawDest = this.getDestination();
        if (rawDest == null) {
            SMAction outlineAction = this.getAction();
            if (outlineAction instanceof SMActionGoTo) {
                rawDest = ((SMActionGoTo)outlineAction).getDestination();
            } else if (outlineAction != null) {
                throw new OutlineNotLocalException("Error: Outline does not reference a local page.");
            }
        }
        SMPageDestination pageDest = null;
        if (rawDest instanceof SMNamedDestination) {
            SMDestinationNameTreeNode destsTree;
            SMNamedDestination namedDest = (SMNamedDestination)rawDest;
            SMDocumentNameDictionary namesDict = doc.getDocumentCatalog().getNames();
            if (namesDict != null && (destsTree = namesDict.getDests()) != null) {
                pageDest = (SMPageDestination)destsTree.getValue(namedDest.getNamedDestination());
            }
        } else if (rawDest instanceof SMPageDestination) {
            pageDest = (SMPageDestination)rawDest;
        } else if (rawDest != null) {
            throw new IOException("Error: Unknown destination type " + rawDest);
        }
        if (pageDest != null && (page = pageDest.getPage()) == null && (pageNumber = pageDest.getPageNumber()) != -1) {
            List allPages = doc.getDocumentCatalog().getAllPages();
            page = (SMPage)allPages.get(pageNumber);
        }
        return page;
    }

    public SMAction getAction() {
        return SMActionFactory.createAction((OMDictionary)this.node.getDictionaryObject(OMName.A));
    }

    public void setAction(SMAction action) {
        this.node.setItem(OMName.A, (OMObjectable)action);
    }

    public SMStructureElement getStructureElement() {
        SMStructureElement se = null;
        OMDictionary dic = (OMDictionary)this.node.getDictionaryObject(OMName.SE);
        if (dic != null) {
            se = new SMStructureElement(dic);
        }
        return se;
    }

    public void setStructuredElement(SMStructureElement structureElement) {
        this.node.setItem(OMName.SE, (OMObjectable)structureElement);
    }

    public SMColorState getTextColor() {
        SMColorState retval = null;
        OMArray csValues = (OMArray)this.node.getDictionaryObject(OMName.C);
        if (csValues == null) {
            csValues = new OMArray();
            csValues.growToSize(3, new OMFloat(0.0f));
            this.node.setItem(OMName.C, (OMBase)csValues);
        }
        retval = new SMColorState(csValues);
        retval.setColorSpace(SMDeviceRGB.INSTANCE);
        return retval;
    }

    public void setTextColor(SMColorState textColor) {
        this.node.setItem(OMName.C, (OMBase)textColor.getOMColorSpaceValue());
    }

    public void setTextColor(Color textColor) {
        OMArray array = new OMArray();
        array.add(new OMFloat((float)textColor.getRed() / 255.0f));
        array.add(new OMFloat((float)textColor.getGreen() / 255.0f));
        array.add(new OMFloat((float)textColor.getBlue() / 255.0f));
        this.node.setItem(OMName.C, (OMBase)array);
    }

    public boolean isItalic() {
        return BitFlagHelper.getFlag(this.node, OMName.F, 1);
    }

    public void setItalic(boolean italic) {
        BitFlagHelper.setFlag(this.node, OMName.F, 1, italic);
    }

    public boolean isBold() {
        return BitFlagHelper.getFlag(this.node, OMName.F, 2);
    }

    public void setBold(boolean bold) {
        BitFlagHelper.setFlag(this.node, OMName.F, 2, bold);
    }
}

