/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.digitalsignature.visible;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.SMRectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.imageio.ImageIO;

public class SMVisibleSignDesigner {
    private Float sigImgWidth;
    private Float sigImgHeight;
    private float xAxis;
    private float yAxis;
    private float pageHeight;
    private float pageWidth;
    private InputStream imgageStream;
    private String signatureFieldName = "sig";
    private byte[] formaterRectangleParams;
    private byte[] AffineTransformParams;
    private float imageSizeInPercents;
    private SMDocument document;

    public SMVisibleSignDesigner(InputStream originalDocumenStream, InputStream imageStream, int page) throws IOException, CryptographyException {
        byte[] byArray = new byte[4];
        byArray[2] = 100;
        byArray[3] = 50;
        this.formaterRectangleParams = byArray;
        byte[] byArray2 = new byte[6];
        byArray2[0] = 1;
        byArray2[3] = 1;
        this.AffineTransformParams = byArray2;
        this.document = null;
        this.signatureImageStream(imageStream);
        this.document = SMDocument.load(originalDocumenStream);
        this.calculatePageSize(this.document, page);
    }

    public SMVisibleSignDesigner(String documentPath, InputStream imageStream, int page) throws IOException, CryptographyException {
        byte[] byArray = new byte[4];
        byArray[2] = 100;
        byArray[3] = 50;
        this.formaterRectangleParams = byArray;
        byte[] byArray2 = new byte[6];
        byArray2[0] = 1;
        byArray2[3] = 1;
        this.AffineTransformParams = byArray2;
        this.document = null;
        this.signatureImageStream(imageStream);
        this.document = SMDocument.load(documentPath);
        this.calculatePageSize(this.document, page);
        this.document.close();
    }

    public SMVisibleSignDesigner(SMDocument doc, InputStream imageStream, int page) throws IOException {
        byte[] byArray = new byte[4];
        byArray[2] = 100;
        byArray[3] = 50;
        this.formaterRectangleParams = byArray;
        byte[] byArray2 = new byte[6];
        byArray2[0] = 1;
        byArray2[3] = 1;
        this.AffineTransformParams = byArray2;
        this.document = null;
        this.signatureImageStream(imageStream);
        this.calculatePageSize(doc, page);
    }

    private void calculatePageSize(SMDocument document, int page) {
        if (page < 1) {
            throw new IllegalArgumentException("First page of pdf is 1, not " + page);
        }
        List pages = document.getDocumentCatalog().getAllPages();
        SMPage firstPage = (SMPage)pages.get(page - 1);
        SMRectangle mediaBox = firstPage.findMediaBox();
        this.pageHeight(mediaBox.getHeight());
        float x = this.pageWidth = mediaBox.getWidth();
        float y = 0.0f;
        this.pageWidth += y;
        float tPercent = 100.0f * y / (x + y);
        this.imageSizeInPercents = 100.0f - tPercent;
    }

    public SMVisibleSignDesigner signatureImage(String path) throws IOException {
        FileInputStream fin = new FileInputStream(path);
        return this.signatureImageStream(fin);
    }

    public SMVisibleSignDesigner zoom(float percent) {
        this.sigImgHeight = Float.valueOf(this.sigImgHeight.floatValue() + this.sigImgHeight.floatValue() * percent / 100.0f);
        this.sigImgWidth = Float.valueOf(this.sigImgWidth.floatValue() + this.sigImgWidth.floatValue() * percent / 100.0f);
        return this;
    }

    public SMVisibleSignDesigner coordinates(float x, float y) {
        this.xAxis(x);
        this.yAxis(y);
        return this;
    }

    public float getxAxis() {
        return this.xAxis;
    }

    public SMVisibleSignDesigner xAxis(float xAxis) {
        this.xAxis = xAxis;
        return this;
    }

    public float getyAxis() {
        return this.yAxis;
    }

    public SMVisibleSignDesigner yAxis(float yAxis) {
        this.yAxis = yAxis;
        return this;
    }

    public float getWidth() {
        return this.sigImgWidth.floatValue();
    }

    public SMVisibleSignDesigner width(float signatureImgWidth) {
        this.sigImgWidth = Float.valueOf(signatureImgWidth);
        return this;
    }

    public float getHeight() {
        return this.sigImgHeight.floatValue();
    }

    public SMVisibleSignDesigner height(float signatureImgHeight) {
        this.sigImgHeight = Float.valueOf(signatureImgHeight);
        return this;
    }

    protected float getTemplateHeight() {
        return this.getPageHeight();
    }

    private SMVisibleSignDesigner pageHeight(float templateHeight) {
        this.pageHeight = templateHeight;
        return this;
    }

    public String getSignatureFieldName() {
        return this.signatureFieldName;
    }

    public SMVisibleSignDesigner signatureFieldName(String signatureFieldName) {
        this.signatureFieldName = signatureFieldName;
        return this;
    }

    public InputStream getImageStream() {
        return this.imgageStream;
    }

    private SMVisibleSignDesigner signatureImageStream(InputStream imageStream) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = imageStream.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        baos.close();
        byte[] byteArray = baos.toByteArray();
        byte[] byteArraySecond = SMVisibleSignDesigner.clone(byteArray);
        ByteArrayInputStream inputForBufferedImage = new ByteArrayInputStream(byteArray);
        ByteArrayInputStream revertInputStream = new ByteArrayInputStream(byteArraySecond);
        if (this.sigImgHeight == null || this.sigImgWidth == null) {
            this.calcualteImageSize(inputForBufferedImage);
        }
        this.imgageStream = revertInputStream;
        return this;
    }

    public static byte[] clone(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copy = new byte[data.length];
        System.arraycopy(data, 0, copy, 0, data.length);
        return copy;
    }

    private void calcualteImageSize(InputStream fis) throws IOException {
        BufferedImage bimg = ImageIO.read(fis);
        int width = bimg.getWidth();
        int height = bimg.getHeight();
        this.sigImgHeight = Float.valueOf(height);
        this.sigImgWidth = Float.valueOf(width);
    }

    public byte[] getAffineTransformParams() {
        return this.AffineTransformParams;
    }

    public SMVisibleSignDesigner affineTransformParams(byte[] affineTransformParams) {
        this.AffineTransformParams = affineTransformParams;
        return this;
    }

    public byte[] getFormaterRectangleParams() {
        return this.formaterRectangleParams;
    }

    public SMVisibleSignDesigner formaterRectangleParams(byte[] formaterRectangleParams) {
        this.formaterRectangleParams = formaterRectangleParams;
        return this;
    }

    public float getPageWidth() {
        return this.pageWidth;
    }

    public SMVisibleSignDesigner pageWidth(float pageWidth) {
        this.pageWidth = pageWidth;
        return this;
    }

    public float getPageHeight() {
        return this.pageHeight;
    }

    public float getImageSizeInPercents() {
        return this.imageSizeInPercents;
    }

    public void imageSizeInPercents(float imageSizeInPercents) {
        this.imageSizeInPercents = imageSizeInPercents;
    }

    public String getSignatureText() {
        throw new UnsupportedOperationException("That method is not yet implemented");
    }

    public SMVisibleSignDesigner signatureText(String signatureText) {
        throw new UnsupportedOperationException("That method is not yet implemented");
    }
}

