/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.digitalsignature.visible;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.graphics.xobject.SMJpeg;
import com.plpdf.smmodel.graphics.xobject.SMXObjectForm;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceDictionary;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceStream;
import com.plpdf.smmodel.interactive.digitalsignature.SMSignature;
import com.plpdf.smmodel.interactive.digitalsignature.visible.PDFTemplateBuilder;
import com.plpdf.smmodel.interactive.digitalsignature.visible.PDFTemplateStructure;
import com.plpdf.smmodel.interactive.digitalsignature.visible.SMVisibleSignDesigner;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.smmodel.interactive.form.SMField;
import com.plpdf.smmodel.interactive.form.SMSignatureField;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class SMVisibleSigBuilder
implements PDFTemplateBuilder {
    private PDFTemplateStructure pdfStructure = new PDFTemplateStructure();

    public void createPage(SMVisibleSignDesigner properties) {
        SMPage page = new SMPage();
        page.setMediaBox(new SMRectangle(properties.getPageWidth(), properties.getPageHeight()));
        this.pdfStructure.setPage(page);
    }

    public void createTemplate(SMPage page) throws IOException {
        SMDocument template = new SMDocument();
        template.addPage(page);
        this.pdfStructure.setTemplate(template);
    }

    public void createAcroForm(SMDocument template) {
        SMAcroForm theAcroForm = new SMAcroForm(template);
        template.getDocumentCatalog().setAcroForm(theAcroForm);
        this.pdfStructure.setAcroForm(theAcroForm);
    }

    public PDFTemplateStructure getStructure() {
        return this.pdfStructure;
    }

    public void createSignatureField(SMAcroForm acroForm) throws IOException {
        SMSignatureField sf = new SMSignatureField(acroForm);
        this.pdfStructure.setSignatureField(sf);
    }

    public void createSignature(SMSignatureField pdSignatureField, SMPage page, String signatureName) throws IOException {
        SMSignature pdSignature = new SMSignature();
        pdSignatureField.setSignature(pdSignature);
        pdSignatureField.getWidget().setPage(page);
        page.getAnnotations().add(pdSignatureField.getWidget());
        pdSignature.setName(signatureName);
        pdSignature.setByteRange(new int[4]);
        pdSignature.setContents(new byte[4096]);
        this.pdfStructure.setPdSignature(pdSignature);
    }

    public void createAcroFormDictionary(SMAcroForm acroForm, SMSignatureField signatureField) throws IOException {
        List<SMField> acroFormFields = acroForm.getFields();
        OMDictionary acroFormDict = acroForm.getDictionary();
        acroFormDict.setDirect(true);
        acroFormDict.setInt(OMName.SIG_FLAGS, 3);
        acroFormFields.add(signatureField);
        acroFormDict.setString(OMName.DA, "/sylfaen 0 Tf 0 g");
        this.pdfStructure.setAcroFormFields(acroFormFields);
        this.pdfStructure.setAcroFormDictionary(acroFormDict);
    }

    public void createSignatureRectangle(SMSignatureField signatureField, SMVisibleSignDesigner properties) throws IOException {
        SMRectangle rect = new SMRectangle();
        rect.setUpperRightX(properties.getxAxis() + properties.getWidth());
        rect.setUpperRightY(properties.getTemplateHeight() - properties.getyAxis());
        rect.setLowerLeftY(properties.getTemplateHeight() - properties.getyAxis() - properties.getHeight());
        rect.setLowerLeftX(properties.getxAxis());
        signatureField.getWidget().setRectangle(rect);
        this.pdfStructure.setSignatureRectangle(rect);
    }

    public void createAffineTransform(byte[] params) {
        AffineTransform transform = new AffineTransform(params[0], params[1], params[2], params[3], params[4], params[5]);
        this.pdfStructure.setAffineTransform(transform);
    }

    public void createProcSetArray() {
        OMArray procSetArr = new OMArray();
        procSetArr.add(OMName.getPDFName("PDF"));
        procSetArr.add(OMName.getPDFName("Text"));
        procSetArr.add(OMName.getPDFName("ImageB"));
        procSetArr.add(OMName.getPDFName("ImageC"));
        procSetArr.add(OMName.getPDFName("ImageI"));
        this.pdfStructure.setProcSet(procSetArr);
    }

    public void createSignatureImage(SMDocument template, InputStream inputStream) throws IOException, PlpdfException {
        SMJpeg img = new SMJpeg(template, inputStream);
        this.pdfStructure.setJpedImage(img);
        inputStream.close();
    }

    public void createFormaterRectangle(byte[] params) {
        SMRectangle formrect = new SMRectangle();
        formrect.setUpperRightX(params[0]);
        formrect.setUpperRightY(params[1]);
        formrect.setLowerLeftX(params[2]);
        formrect.setLowerLeftY(params[3]);
        this.pdfStructure.setFormaterRectangle(formrect);
    }

    public void createHolderFormStream(SMDocument template) {
        SMStream holderForm = new SMStream(template);
        this.pdfStructure.setHolderFormStream(holderForm);
    }

    public void createHolderFormResources() {
        SMResources holderFormResources = new SMResources();
        this.pdfStructure.setHolderFormResources(holderFormResources);
    }

    public void createHolderForm(SMResources holderFormResources, SMStream holderFormStream, SMRectangle formrect) {
        SMXObjectForm holderForm = new SMXObjectForm(holderFormStream);
        holderForm.setResources(holderFormResources);
        holderForm.setBBox(formrect);
        holderForm.setFormType(1);
        this.pdfStructure.setHolderForm(holderForm);
    }

    public void createAppearanceDictionary(SMXObjectForm holderForml, SMSignatureField signatureField) throws IOException {
        SMAppearanceDictionary appearance = new SMAppearanceDictionary();
        appearance.getOMObject().setDirect(true);
        SMAppearanceStream appearanceStream = new SMAppearanceStream(holderForml.getOMStream());
        appearance.setNormalAppearance(appearanceStream);
        signatureField.getWidget().setAppearance(appearance);
        this.pdfStructure.setAppearanceDictionary(appearance);
    }

    public void createInnerFormStream(SMDocument template) {
        SMStream innterFormStream = new SMStream(template);
        this.pdfStructure.setInnterFormStream(innterFormStream);
    }

    public void createInnerFormResource() {
        SMResources innerFormResources = new SMResources();
        this.pdfStructure.setInnerFormResources(innerFormResources);
    }

    public void createInnerForm(SMResources innerFormResources, SMStream innerFormStream, SMRectangle formrect) {
        SMXObjectForm innerForm = new SMXObjectForm(innerFormStream);
        innerForm.setResources(innerFormResources);
        innerForm.setBBox(formrect);
        innerForm.setFormType(1);
        this.pdfStructure.setInnerForm(innerForm);
    }

    public void insertInnerFormToHolerResources(SMXObjectForm innerForm, SMResources holderFormResources) throws IOException {
        String name = holderFormResources.addXObject(innerForm, "FRM");
        this.pdfStructure.setInnerFormName(name);
    }

    public void createImageFormStream(SMDocument template) {
        SMStream imageFormStream = new SMStream(template);
        this.pdfStructure.setImageFormStream(imageFormStream);
    }

    public void createImageFormResources() {
        SMResources imageFormResources = new SMResources();
        this.pdfStructure.setImageFormResources(imageFormResources);
    }

    public void createImageForm(SMResources imageFormResources, SMResources innerFormResource, SMStream imageFormStream, SMRectangle formrect, AffineTransform affineTransform, SMJpeg img) throws IOException {
        SMXObjectForm imageForm = new SMXObjectForm(imageFormStream);
        imageForm.setBBox(formrect);
        imageForm.setMatrix(affineTransform);
        imageForm.setResources(imageFormResources);
        imageForm.setFormType(1);
        imageFormResources.getOMObject().setDirect(true);
        String imageFormName = innerFormResource.addXObject(imageForm, "n");
        String imageName = imageFormResources.addXObject(img, "img");
        this.pdfStructure.setImageForm(imageForm);
        this.pdfStructure.setImageFormName(imageFormName);
        this.pdfStructure.setImageName(imageName);
    }

    public void injectProcSetArray(SMXObjectForm innerForm, SMPage page, SMResources innerFormResources, SMResources imageFormResources, SMResources holderFormResources, OMArray procSet) {
        innerForm.getResources().getOMDictionary().setItem(OMName.PROC_SET, (OMBase)procSet);
        page.getOMDictionary().setItem(OMName.PROC_SET, (OMBase)procSet);
        innerFormResources.getOMDictionary().setItem(OMName.PROC_SET, (OMBase)procSet);
        imageFormResources.getOMDictionary().setItem(OMName.PROC_SET, (OMBase)procSet);
        holderFormResources.getOMDictionary().setItem(OMName.PROC_SET, (OMBase)procSet);
    }

    public void injectAppearanceStreams(SMStream holderFormStream, SMStream innterFormStream, SMStream imageFormStream, String imageObjectName, String imageName, String innerFormName, SMVisibleSignDesigner properties) throws IOException {
        String imgFormComment = "q 100 0 0 50 0 0 cm /" + imageName + " Do Q\n";
        String holderFormComment = "q 1 0 0 1 0 0 cm /" + innerFormName + " Do Q \n";
        String innerFormComment = "q 1 0 0 1 0 0 cm /" + imageObjectName + " Do Q\n";
        this.appendRawCommands(this.pdfStructure.getHolderFormStream().createOutputStream(), holderFormComment);
        this.appendRawCommands(this.pdfStructure.getInnterFormStream().createOutputStream(), innerFormComment);
        this.appendRawCommands(this.pdfStructure.getImageFormStream().createOutputStream(), imgFormComment);
    }

    public void appendRawCommands(OutputStream os, String commands) throws IOException {
        os.write(commands.getBytes("UTF-8"));
        os.close();
    }

    public void createVisualSignature(SMDocument template) {
        this.pdfStructure.setVisualSignature(template.getDocument());
    }

    public void createWidgetDictionary(SMSignatureField signatureField, SMResources holderFormResources) throws IOException {
        OMDictionary widgetDict = signatureField.getWidget().getDictionary();
        widgetDict.setNeedToBeUpdate(true);
        widgetDict.setItem(OMName.DR, holderFormResources.getOMObject());
        this.pdfStructure.setWidgetDictionary(widgetDict);
    }

    public void closeTemplate(SMDocument template) throws IOException {
        template.close();
        this.pdfStructure.getTemplate().close();
    }
}

