/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.digitalsignature.visible;

import com.plpdf.exceptions.OMVisitorException;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.smmodel.graphics.xobject.SMXObjectForm;
import com.plpdf.smmodel.interactive.digitalsignature.visible.PDFTemplateBuilder;
import com.plpdf.smmodel.interactive.digitalsignature.visible.PDFTemplateStructure;
import com.plpdf.smmodel.interactive.digitalsignature.visible.SMVisibleSignDesigner;
import com.plpdf.smmodel.interactive.form.SMAcroForm;
import com.plpdf.smmodel.interactive.form.SMSignatureField;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class PDFTemplateCreator {
    PDFTemplateBuilder pdfBuilder;

    public PDFTemplateCreator(PDFTemplateBuilder bookBuilder) {
        this.pdfBuilder = bookBuilder;
    }

    public PDFTemplateStructure getPdfStructure() {
        return this.pdfBuilder.getStructure();
    }

    public InputStream buildPDF(SMVisibleSignDesigner properties) throws Exception {
        PDFTemplateStructure pdfStructure = this.pdfBuilder.getStructure();
        this.pdfBuilder.createProcSetArray();
        this.pdfBuilder.createPage(properties);
        SMPage page = pdfStructure.getPage();
        this.pdfBuilder.createTemplate(page);
        SMDocument template = pdfStructure.getTemplate();
        this.pdfBuilder.createAcroForm(template);
        SMAcroForm acroForm = pdfStructure.getAcroForm();
        this.pdfBuilder.createSignatureField(acroForm);
        SMSignatureField pdSignatureField = pdfStructure.getSignatureField();
        this.pdfBuilder.createSignature(pdSignatureField, page, properties.getSignatureFieldName());
        this.pdfBuilder.createAcroFormDictionary(acroForm, pdSignatureField);
        this.pdfBuilder.createAffineTransform(properties.getAffineTransformParams());
        AffineTransform transform = pdfStructure.getAffineTransform();
        this.pdfBuilder.createSignatureRectangle(pdSignatureField, properties);
        this.pdfBuilder.createFormaterRectangle(properties.getFormaterRectangleParams());
        SMRectangle formater = pdfStructure.getFormaterRectangle();
        this.pdfBuilder.createSignatureImage(template, properties.getImageStream());
        this.pdfBuilder.createHolderFormStream(template);
        SMStream holderFormStream = pdfStructure.getHolderFormStream();
        this.pdfBuilder.createHolderFormResources();
        SMResources holderFormResources = pdfStructure.getHolderFormResources();
        this.pdfBuilder.createHolderForm(holderFormResources, holderFormStream, formater);
        this.pdfBuilder.createAppearanceDictionary(pdfStructure.getHolderForm(), pdSignatureField);
        this.pdfBuilder.createInnerFormStream(template);
        this.pdfBuilder.createInnerFormResource();
        SMResources innerFormResource = pdfStructure.getInnerFormResources();
        this.pdfBuilder.createInnerForm(innerFormResource, pdfStructure.getInnterFormStream(), formater);
        SMXObjectForm innerForm = pdfStructure.getInnerForm();
        this.pdfBuilder.insertInnerFormToHolerResources(innerForm, holderFormResources);
        this.pdfBuilder.createImageFormStream(template);
        SMStream imageFormStream = pdfStructure.getImageFormStream();
        this.pdfBuilder.createImageFormResources();
        SMResources imageFormResources = pdfStructure.getImageFormResources();
        this.pdfBuilder.createImageForm(imageFormResources, innerFormResource, imageFormStream, formater, transform, pdfStructure.getJpedImage());
        this.pdfBuilder.injectProcSetArray(innerForm, page, innerFormResource, imageFormResources, holderFormResources, pdfStructure.getProcSet());
        String imgFormName = pdfStructure.getImageFormName();
        String imgName = pdfStructure.getImageName();
        String innerFormName = pdfStructure.getInnerFormName();
        this.pdfBuilder.injectAppearanceStreams(holderFormStream, imageFormStream, imageFormStream, imgFormName, imgName, innerFormName, properties);
        this.pdfBuilder.createVisualSignature(template);
        this.pdfBuilder.createWidgetDictionary(pdSignatureField, holderFormResources);
        ByteArrayInputStream in = null;
        try {
            in = pdfStructure.getTemplateAppearanceStream();
        }
        catch (OMVisitorException oMVisitorException) {
            // empty catch block
        }
        template.close();
        return in;
    }
}

