/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.smmodel.interactive.digitalsignature;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMString;
import com.plpdf.pdfwriter.OMFilterInputStream;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.interactive.digitalsignature.SMPropBuild;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;

public class SMSignature
implements OMObjectable {
    private OMDictionary dictionary;
    public static final OMName FILTER_ADOBE_PPKLITE = OMName.ADOBE_PPKLITE;
    public static final OMName FILTER_ENTRUST_PPKEF = OMName.ENTRUST_PPKEF;
    public static final OMName FILTER_CICI_SIGNIT = OMName.CICI_SIGNIT;
    public static final OMName FILTER_VERISIGN_PPKVS = OMName.VERISIGN_PPKVS;
    public static final OMName SUBFILTER_ADBE_X509_RSA_SHA1 = OMName.ADBE_X509_RSA_SHA1;
    public static final OMName SUBFILTER_ADBE_PKCS7_DETACHED = OMName.ADBE_PKCS7_DETACHED;
    public static final OMName SUBFILTER_ETSI_CADES_DETACHED = OMName.getPDFName("ETSI.CAdES.detached");
    public static final OMName SUBFILTER_ADBE_PKCS7_SHA1 = OMName.ADBE_PKCS7_SHA1;

    public SMSignature() {
        this.dictionary = new OMDictionary();
        this.dictionary.setItem(OMName.TYPE, (OMBase)OMName.SIG);
    }

    public SMSignature(OMDictionary dict) {
        this.dictionary = dict;
    }

    public OMBase getOMObject() {
        return this.getDictionary();
    }

    public OMDictionary getDictionary() {
        return this.dictionary;
    }

    public void setType(OMName type) {
        this.dictionary.setItem(OMName.TYPE, (OMBase)type);
    }

    public void setFilter(OMName filter) {
        this.dictionary.setItem(OMName.FILTER, (OMBase)filter);
    }

    public void setSubFilter(OMName subfilter) {
        this.dictionary.setItem(OMName.SUBFILTER, (OMBase)subfilter);
    }

    public void setName(String name) throws IOException {
        this.dictionary.setString(OMName.NAME, name);
    }

    public void setLocation(String location) throws IOException {
        this.dictionary.setString(OMName.LOCATION, location);
    }

    public void setReason(String reason) throws IOException {
        this.dictionary.setString(OMName.REASON, reason);
    }

    public void setContactInfo(String contactInfo) throws IOException {
        this.dictionary.setString(OMName.CONTACT_INFO, contactInfo);
    }

    public void setSignDate(Calendar cal) throws IOException {
        this.dictionary.setDate(OMName.M, cal);
    }

    public String getFilter() {
        return this.dictionary.getNameAsString(OMName.FILTER);
    }

    public String getSubFilter() {
        return this.dictionary.getNameAsString(OMName.SUBFILTER);
    }

    public String getName() {
        return this.dictionary.getString(OMName.NAME);
    }

    public String getLocation() {
        return this.dictionary.getString(OMName.LOCATION);
    }

    public String getReason() {
        return this.dictionary.getString(OMName.REASON);
    }

    public String getContactInfo() {
        return this.dictionary.getString(OMName.CONTACT_INFO);
    }

    public Calendar getSignDate() {
        try {
            return this.dictionary.getDate(OMName.M);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getSignDateString() {
        return this.dictionary.getString(OMName.M);
    }

    public void setByteRange(int[] range) {
        if (range.length != 4) {
            return;
        }
        OMArray ary = new OMArray();
        int[] nArray = range;
        int n = range.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            ary.add(OMInteger.get(i));
            ++n2;
        }
        this.dictionary.setItem(OMName.BYTERANGE, (OMBase)ary);
    }

    public int[] getByteRange() {
        OMArray byteRange = (OMArray)this.dictionary.getDictionaryObject(OMName.BYTERANGE);
        int[] ary = new int[byteRange.size()];
        int i = 0;
        while (i < ary.length) {
            ary[i] = byteRange.getInt(i);
            ++i;
        }
        return ary;
    }

    public byte[] getContents(InputStream pdfFile) throws IOException {
        int[] byteRange = this.getByteRange();
        int begin = byteRange[0] + byteRange[1] + 1;
        int end = byteRange[2] - begin;
        return this.getContents(new OMFilterInputStream(pdfFile, new int[]{begin, end}));
    }

    public byte[] getContents(byte[] pdfFile) throws IOException {
        int[] byteRange = this.getByteRange();
        int begin = byteRange[0] + byteRange[1] + 1;
        int end = byteRange[2] - begin;
        return this.getContents(new OMFilterInputStream(pdfFile, new int[]{begin, end}));
    }

    private byte[] getContents(OMFilterInputStream fis) throws IOException {
        int c;
        ByteArrayOutputStream byteOS = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        while ((c = fis.read(buffer)) != -1) {
            if (buffer[0] == 60 || buffer[0] == 40) {
                byteOS.write(buffer, 1, c);
                continue;
            }
            if (buffer[c - 1] == 62 || buffer[c - 1] == 41) {
                byteOS.write(buffer, 0, c - 1);
                continue;
            }
            byteOS.write(buffer, 0, c);
        }
        fis.close();
        return OMString.createFromHexString(byteOS.toString()).getBytes();
    }

    public void setContents(byte[] bytes) {
        OMString string = new OMString(bytes);
        string.setForceHexForm(true);
        this.dictionary.setItem(OMName.CONTENTS, (OMBase)string);
    }

    public byte[] getSignedContent(InputStream pdfFile) throws IOException {
        FilterInputStream fis = null;
        try {
            fis = new OMFilterInputStream(pdfFile, this.getByteRange());
            byte[] byArray = ((OMFilterInputStream)fis).toByteArray();
            return byArray;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public byte[] getSignedContent(byte[] pdfFile) throws IOException {
        FilterInputStream fis = null;
        try {
            fis = new OMFilterInputStream(pdfFile, this.getByteRange());
            byte[] byArray = ((OMFilterInputStream)fis).toByteArray();
            return byArray;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public SMPropBuild getPropBuild() {
        SMPropBuild propBuild = null;
        OMDictionary propBuildDic = (OMDictionary)this.dictionary.getDictionaryObject(OMName.PROP_BUILD);
        if (propBuildDic != null) {
            propBuild = new SMPropBuild(propBuildDic);
        }
        return propBuild;
    }

    public void setPropBuild(SMPropBuild propBuild) {
        this.dictionary.setItem(OMName.PROP_BUILD, (OMObjectable)propBuild);
    }
}

